/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.sql.PooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverableUniversalPooledConnectionBase;
import oracle.ucp.jdbc.JDBCConnectionPool;

public class JDBCUniversalPooledConnection
extends FailoverableUniversalPooledConnectionBase {
    static final String CLASS_NAME = JDBCUniversalPooledConnection.class.getName();
    private final JDBCConnectionPool m_cp;
    private int m_maxStatements = 0;

    public JDBCUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
        this.m_cp = connectionPool;
    }

    @Override
    public void validate(UniversalPooledConnection.ValidationType validationType, int timeout) {
        boolean isValid;
        String strSql = this.m_cp.getSQLForValidateConnection();
        boolean bl = isValid = strSql != null && !strSql.equals("") ? this.validateConnectionWithSQL(strSql, timeout) : this.validateConnectionWithoutSQL(timeout);
        if (!isValid) {
            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is invalid");
        }
    }

    @Override
    public CompletionStage<Void> validateAsync(UniversalPooledConnection.ValidationType validationType, int timeout, Executor executor) {
        throw new NoSuchMethodError("asynchronous validation is not supported in generic JDBC");
    }

    /*
     * Exception decompiling
     */
    private boolean validateConnectionWithSQL(String sqlExpression, int timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean validateConnectionWithoutSQL(int timeout) {
        Connection conn;
        boolean valid = false;
        try {
            conn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "validateConnectionWithoutSQL", "", null, e, new Object[0]);
            boolean bl = false;
            this.trace(Level.FINEST, CLASS_NAME, "validateConnectionWithoutSQL", "valid={0}", null, null, valid);
            return bl;
        }
        {
            catch (Throwable throwable) {
                this.trace(Level.FINEST, CLASS_NAME, "validateConnectionWithoutSQL", "valid={0}", null, null, valid);
                throw throwable;
            }
        }
        try {
            boolean e = valid = conn.isValid(timeout);
        }
        catch (SQLException e) {
            boolean bl = false;
            this.trace(Level.FINEST, CLASS_NAME, "validateConnectionWithoutSQL", "valid={0}", null, null, valid);
            return bl;
        }
        this.trace(Level.FINEST, CLASS_NAME, "validateConnectionWithoutSQL", "valid={0}", null, null, valid);
        return e;
    }

    public Connection getSQLConnection(Object physicalConnection) throws SQLException {
        if (physicalConnection instanceof Connection) {
            return (Connection)physicalConnection;
        }
        if (physicalConnection instanceof PooledConnection) {
            return ((PooledConnection)physicalConnection).getConnection();
        }
        return null;
    }

    @Override
    protected void initFailoverParameters() throws UniversalConnectionPoolException {
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    public synchronized void setMaxStatements(int maxStatements) throws SQLException {
        this.m_maxStatements = maxStatements;
    }
}

