import datetime
from concurrent.futures import Future
from datetime import timedelta
from typing import (
    Any,
    Dict,
    List,
    Optional,
    Union,
    Tuple,
)

from .utils.data_types import *


class Browser:
    timeout: Any = ...
    def __init__(self, timeout: timedelta = timedelta(seconds=10.0), enable_playwright_debug: bool = False, auto_closing_level: AutoClosingLevel = AutoClosingLevel.TEST, retry_assertions_for: timedelta = timedelta(seconds=1.0), run_on_failure: str = 'Take Screenshot', external_browser_executable: Optional[Dict[SupportedBrowsers, str]] = None, jsextension: Optional[str] = None): ...
    def add_cookie(self, name: str, value: str, url: Optional[str] = None, domain: Optional[str] = None, path: Optional[str] = None, expires: Optional[str] = None, httpOnly: Optional[bool] = None, secure: Optional[bool] = None, sameSite: Optional[CookieSameSite] = None): ...
    def add_style_tag(self, content: str): ...
    def check_checkbox(self, selector: str): ...
    def clear_text(self, selector: str): ...
    def click(self, selector: str, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: Optional[timedelta] = None, position_x: Optional[float] = None, position_y: Optional[float] = None, force: bool = False, noWaitAfter: bool = False, *modifiers: KeyboardModifier): ...
    def close_browser(self, browser: str = 'CURRENT'): ...
    def close_context(self, context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def close_page(self, page: str = 'CURRENT', context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def connect_to_browser(self, wsEndpoint: str, browser: SupportedBrowsers = SupportedBrowsers.chromium): ...
    def delete_all_cookies(self): ...
    def deselect_options(self, selector: str): ...
    def download(self, url: str): ...
    def drag_and_drop(self, selector_from: str, selector_to: str, steps: int = 1): ...
    def drag_and_drop_by_coordinates(self, from_x: float, from_y: float, to_x: float, to_y: float, steps: int = 1): ...
    def eat_all_cookies(self): ...
    def execute_javascript(self, function: str, selector: str = ''): ...
    def fill_secret(self, selector: str, secret: str): ...
    def fill_text(self, selector: str, text: str): ...
    def focus(self, selector: str): ...
    def get_attribute(self, selector: str, attribute: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_attribute_names(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, *assertion_expected, message: Optional[Union[str, None]] = None): ...
    def get_boundingbox(self, selector: str, key: BoundingBoxFields = BoundingBoxFields.ALL, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_browser_catalog(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_browser_ids(self, browser: SelectionType = SelectionType.ALL): ...
    def get_checkbox_state(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, expected_state: Union[bool, str] = 'Unchecked', message: Optional[str] = None): ...
    def get_classes(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, *assertion_expected, message: Optional[Union[str, None]] = None): ...
    def get_client_size(self, selector: Optional[str] = None, key: SizeFields = SizeFields.ALL, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_context_ids(self, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_cookie(self, cookie: str, return_type: CookieType = CookieType.dictionary): ...
    def get_cookies(self, return_type: CookieType = CookieType.dictionary): ...
    def get_device(self, name: str): ...
    def get_devices(self): ...
    def get_element(self, selector: str): ...
    def get_element_count(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, expected_value: Union[int, str] = 0, message: Optional[str] = None): ...
    def get_element_state(self, selector: str, state: ElementStateKey = ElementStateKey.visible, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: bool = True, message: Optional[str] = None): ...
    def get_elements(self, selector: str): ...
    def get_page_ids(self, page: SelectionType = SelectionType.ALL, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_page_source(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_property(self, selector: str, property: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_scroll_position(self, selector: Optional[str] = None, key: AreaFields = AreaFields.ALL, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_scroll_size(self, selector: Optional[str] = None, key: SizeFields = SizeFields.ALL, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_select_options(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_selected_options(self, selector: str, option_attribute: SelectAttribute = SelectAttribute.label, assertion_operator: Optional[AssertionOperator] = None, *assertion_expected): ...
    def get_style(self, selector: str, key: str = 'ALL', assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_text(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_textfield_value(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_title(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_url(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def get_viewport_size(self, key: SizeFields = SizeFields.ALL, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def go_back(self): ...
    def go_forward(self): ...
    def go_to(self, url: str, timeout: Optional[timedelta] = None): ...
    def handle_future_dialogs(self, action: DialogAction, prompt_input: str = ''): ...
    def highlight_elements(self, selector: str, duration: timedelta = timedelta(seconds=5.0), width: str = '2px', style: str = 'dotted', color: str = 'blue'): ...
    def hover(self, selector: str, position_x: Optional[float] = None, position_y: Optional[float] = None, force: bool = False, *modifiers: KeyboardModifier): ...
    def http(self, url: str, method: RequestMethod = RequestMethod.GET, body: Optional[str] = None, headers: Optional[dict] = None): ...
    def keyboard_input(self, action: KeyboardInputAction, input: str, delay = 0): ...
    def keyboard_key(self, action: KeyAction, key: str): ...
    def local_storage_clear(self): ...
    def local_storage_get_item(self, key: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None, message: Optional[str] = None): ...
    def local_storage_remove_item(self, key: str): ...
    def local_storage_set_item(self, key: str, value: str): ...
    def mouse_button(self, action: MouseButtonAction, x: Optional[float] = None, y: Optional[float] = None, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: int = 0): ...
    def mouse_move(self, x: float, y: float, steps: int = 1): ...
    def mouse_move_relative_to(self, selector: str, x: float = 0.0, y: float = 0.0, steps: int = 1): ...
    def new_browser(self, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True, executablePath: Optional[str] = None, args: Optional[List[str]] = None, ignoreDefaultArgs: Optional[List[str]] = None, proxy: Optional[Proxy] = None, downloadsPath: Optional[str] = None, handleSIGINT: bool = True, handleSIGTERM: bool = True, handleSIGHUP: bool = True, timeout: timedelta = timedelta(seconds=30.0), env: Optional[Dict] = None, devtools: bool = False, slowMo: timedelta = timedelta(seconds=0.0)): ...
    def new_context(self, acceptDownloads: bool = False, ignoreHTTPSErrors: bool = False, bypassCSP: bool = False, viewport: Optional[ViewportDimensions] = None, userAgent: Optional[str] = None, deviceScaleFactor: float = 1.0, isMobile: bool = False, hasTouch: bool = False, javaScriptEnabled: bool = True, timezoneId: Optional[str] = None, geolocation: Optional[GeoLocation] = None, locale: Optional[str] = None, permissions: Optional[List[str]] = None, extraHTTPHeaders: Optional[Dict[str, str]] = None, offline: bool = False, httpCredentials: Optional[HttpCredentials] = None, colorScheme: Optional[ColorScheme] = None, proxy: Optional[Proxy] = None, videosPath: Optional[str] = None, videoSize: Optional[ViewportDimensions] = None, defaultBrowserType: Optional[SupportedBrowsers] = None, hideRfBrowser: bool = False, recordVideo: Optional[RecordVideo] = None): ...
    def new_page(self, url: Optional[str] = None): ...
    def open_browser(self, url: Optional[str] = None, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = False, pause_on_failure: bool = True): ...
    def press_keys(self, selector: str, *keys: str): ...
    def promise_to(self, kw: str, *args): ...
    def promise_to_wait_for_download(self, saveAs: str = ''): ...
    def register_keyword_to_run_on_failure(self, keyword: Union[str, None]): ...
    def reload(self): ...
    def scroll_by(self, selector: Optional[str] = None, vertical: str = 'height', horizontal: str = '0', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def scroll_to(self, selector: Optional[str] = None, vertical: str = 'top', horizontal: str = 'left', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def select_options_by(self, selector: str, attribute: SelectAttribute, *values): ...
    def session_storage_clear(self): ...
    def session_storage_get_item(self, key: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def session_storage_remove_item(self, key: str): ...
    def session_storage_set_item(self, key: str, value: str): ...
    def set_browser_timeout(self, timeout: timedelta): ...
    def set_geolocation(self, latitude: float, longitude: float, accuracy: Optional[float] = None): ...
    def set_offline(self, offline: bool = True): ...
    def set_retry_assertions_for(self, timeout: timedelta): ...
    def set_viewport_size(self, width: int, height: int): ...
    def switch_browser(self, id: str): ...
    def switch_context(self, id: str, browser: str = 'CURRENT'): ...
    def switch_page(self, id: str, context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def take_screenshot(self, filename: str = 'robotframework-browser-screenshot-{index}', selector: str = '', fullPage: bool = False): ...
    def type_secret(self, selector: str, secret: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def type_text(self, selector: str, text: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def uncheck_checkbox(self, selector: str): ...
    def upload_file(self, path: str): ...
    def wait_for(self, *promises: Future): ...
    def wait_for_all_promises(self): ...
    def wait_for_download(self, saveAs: str = ''): ...
    def wait_for_elements_state(self, selector: str, state: ElementState = ElementState.visible, timeout: Optional[timedelta] = None, message: Optional[str] = None): ...
    def wait_for_function(self, function: str, selector: str = '', polling: Union[str, datetime.timedelta] = 'raf', timeout: Optional[timedelta] = None, message: Optional[str] = None): ...
    def wait_for_request(self, matcher: str = '', timeout: Optional[timedelta] = None): ...
    def wait_for_response(self, matcher: str = '', timeout: Optional[timedelta] = None): ...
    def wait_until_network_is_idle(self, timeout: Optional[timedelta] = None): ...
    def get_timeout(self, timeout: Union[timedelta, None]) -> float: ...
    def convert_timeout(self, timeout: Union[timedelta, float]) -> float: ...
    def millisecs_to_timestr(self, timeout: float)  -> str: ...

