"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 * @description creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d;
        super(scope, id);
        const dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: (_b = props.billingMode) !== null && _b !== void 0 ? _b : dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_c = props.partitionKey) !== null && _c !== void 0 ? _c : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            pointInTimeRecovery: true,
        });
        const backupPlan = backup.BackupPlan.daily35DayRetention(this, 'BackupPlan', new backup.BackupVault(this, 'BackupVault', {
            backupVaultName: (_d = props.backupVaultName) !== null && _d !== void 0 ? _d : `${props.tableName}-backup-vault`,
            blockRecoveryPointDeletion: true,
        }));
        backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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