"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DarkTheme = exports.DarkPalette = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const palette_1 = require("./palette");
/** Dark theme color palette */
var DarkPalette;
(function (DarkPalette) {
    DarkPalette["PUBLIC"] = "#E9F3E6";
    DarkPalette["PRIVATE"] = "#E6F2F8";
    DarkPalette["GENERIC"] = "#FAFAFA33";
    DarkPalette["PRIMARY"] = "#FAFAFA";
    DarkPalette["SECONDARY"] = "#5B9BD5";
    DarkPalette["TERTIARY"] = "#8FA7C4";
})(DarkPalette = exports.DarkPalette || (exports.DarkPalette = {}));
/** Dark theme definition */
exports.DarkTheme = {
    id: "dark",
    backgrounds: {
        base: palette_1.BasePalette.DARK_BLUE,
        private: DarkPalette.PRIVATE,
        public: DarkPalette.PUBLIC,
        generic: DarkPalette.GENERIC,
    },
    text: {
        default: palette_1.BasePalette.WHITE,
        primary: DarkPalette.PRIMARY,
        secondary: DarkPalette.SECONDARY,
        tertiary: DarkPalette.TERTIARY,
    },
    groups: {
        cloud: {
            color: "#FAFAFA",
            bgcolor: false,
            borderColor: "#FAFAFA",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#FAFAFA",
            bgcolor: false,
            borderColor: "#FAFAFA",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#00A0C8",
            bgcolor: false,
            borderColor: "#00A0C8",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#00A0C8",
            bgcolor: false,
            borderColor: "#00A0C8",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#FC584C",
            bgcolor: false,
            borderColor: "#FC584C",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#69AE35",
            bgcolor: false,
            borderColor: "#69AE35",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#69AE35",
            bgcolor: false,
            borderColor: "#69AE35",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#8FA7C4",
            bgcolor: false,
            borderColor: "#8FA7C4",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#8FA7C4",
            bgcolor: false,
            borderColor: "#8FA7C4",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#FF4F8B",
            bgcolor: false,
            borderColor: "#FF4F8B",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#8FA7C4",
            bgcolor: "magenta",
            borderColor: "#8FA7C4",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#FAFAFACC",
            bgcolor: "#FAFAFA33",
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: DarkPalette.GENERIC,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: DarkPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: DarkPalette.TERTIARY,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: DarkPalette.SECONDARY,
            tail: "normal",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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