from typing import List

from aidkit_client.aidkit_api import HTTPService
from aidkit_client.constants import Constants
from aidkit_client.endpoints.models import RequiredContextDescription
from aidkit_client.exceptions import AidkitCLIError, ResourceWithIdNotFoundError
from pydantic.main import BaseModel


# this is not autogenerated so we do not have to include the whole
# spec including all the Registrables
class PipelineResponse(BaseModel):
    id: int
    name: str
    context: List[RequiredContextDescription]


class ListPipelineResponse(BaseModel):
    pipelines: List[PipelineResponse]


class PipelinesAPI:
    api: HTTPService

    def __init__(self, api: HTTPService):
        self.api = api

    async def get_by_id(self, pipeline_id: int) -> PipelineResponse:
        result = await self.api.get(
            path=f"{Constants.PIPELINES_PATH}/{pipeline_id}",
            parameters=None,
        )
        if result.is_not_found:
            raise ResourceWithIdNotFoundError(
                f"Pipeline with ID: {pipeline_id} not found"
            )
        if not result.is_success:
            raise AidkitCLIError(
                f"Error fetching Pipeline with ID: {pipeline_id}. Error: {result.body}"
            )
        return PipelineResponse(**result.body)

    async def get_all(self) -> List[PipelineResponse]:
        result = await self.api.get(path=Constants.PIPELINES_PATH, parameters=None)
        if not result.is_success:
            raise AidkitCLIError(f"Error fetching pipeline list. Error: {result.body}")
        return ListPipelineResponse(**result.body).pipelines
