# generated by datamodel-codegen:
#   filename:  <stdin>

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field
from typing_extensions import Literal


class MLModelVersionResponse(BaseModel):
    """
    MLModel version response model.
    """

    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    pipeline_run_ids: List[int] = Field(..., title="Pipeline Run Ids")


class ListMLModelVersionResponse(BaseModel):
    """
    List MLModel version response model.
    """

    ml_model_versions: List[MLModelVersionResponse] = Field(
        ..., title="Ml Model Versions"
    )


class FrameworkType(Enum):
    """
    Identification of the type of deep learning framework.

    Required for parsing model binaries with the correct libraries.
    """

    TENSORFLOW = "TENSORFLOW"
    PYTORCH = "PYTORCH"


class DimensionModel(BaseModel):
    """
    Dimension has an axis and length field.
    """

    axis: int = Field(..., title="Axis")
    length: Union[int, Literal["*"]] = Field(..., title="Length")


class GrayScaleChannelDimensionModel(BaseModel):
    """
    Gray scale channel dimension must be of length 1.
    """

    axis: int = Field(..., title="Axis")
    length: Literal[1] = Field(1, title="Length")


class GrayScaleImageInputDimensionsModel(BaseModel):
    """
    Gray Scale Image input has optional batch dimension.
    """

    width: DimensionModel = Field(
        ..., description="Width axis index and length", title="Width axis"
    )
    height: DimensionModel = Field(
        ..., description="Height axis index and length", title="Height axis"
    )
    channel: GrayScaleChannelDimensionModel = Field(
        ..., description="Channel axis index", title="Channel axis"
    )
    batch: Optional[DimensionModel] = Field(
        None, description="Batch axis and length", title="Batch axis"
    )


class GrayScaleImageInputSpecs(BaseModel):
    """
    Specifications for ColorImage InputSpecification.
    """

    dimensions: GrayScaleImageInputDimensionsModel
    name: Literal["GrayScaleImage"] = Field("GrayScaleImage", title="Image (Grayscale)")


class ColorChannelDimensionModel(BaseModel):
    """
    Color channel dimension must be of length 3.
    """

    axis: int = Field(..., title="Axis")
    length: Literal[3] = Field(3, title="Length")


class ColorImageInputDimensionsModel(BaseModel):
    """
    Color Image input has optional batch dimension.
    """

    width: DimensionModel = Field(
        ..., description="Width axis index and length", title="Width axis"
    )
    height: DimensionModel = Field(
        ..., description="Height axis index and length", title="Height axis"
    )
    channel: ColorChannelDimensionModel = Field(
        ..., description="Channel axis index", title="Channel axis"
    )
    batch: Optional[DimensionModel] = Field(
        None, description="Batch axis and length", title="Batch axis"
    )


class ColorImageInputSpecs(BaseModel):
    """
    Specifications for ColorImage InputSpecification.
    """

    dimensions: ColorImageInputDimensionsModel
    name: Literal["ColorImage"] = Field("ColorImage", title="Image (Color)")


class NgramDimensionsModel(BaseModel):
    """
    Ngram must have an index dimension, and it may have any other dimension.
    """

    feature: Optional[DimensionModel] = Field(
        None, description="Feature axis index and length", title="Feature axis"
    )
    index: DimensionModel = Field(
        ..., description="Index axis index and length", title="Index axis"
    )


class NgramInputSpecs(BaseModel):
    """
    Specifications for Ngram InputSpecification.
    """

    dimensions: NgramDimensionsModel
    name: Literal["Ngram"] = Field("Ngram", title="Text")


class DictOutputFormat(BaseModel):
    """
    Dictionary output target.
    """

    name: Literal["Dict"] = Field("Dict", title="Dictionary of Tensors")
    output_target: str = Field(..., title="Output Target")


class SingleOutputFormat(BaseModel):
    """
    Single output target.
    """

    name: Literal["Single"] = Field("Single", title="Single Tensor")


class OutputDimensionModel(BaseModel):
    """
    Output dimension can be of any length.
    """

    axis: int = Field(..., title="Axis")
    length: Literal["*"] = Field("*", title="Length")


class SegmentationScoreDimensionsModel(BaseModel):
    """
    Segmentation Output has width, height, and class dimensions.
    """

    width: OutputDimensionModel = Field(..., title="Width axis")
    height: OutputDimensionModel = Field(..., title="Height axis")
    class_: OutputDimensionModel = Field(..., title="Class axis")
    batch: Optional[OutputDimensionModel] = Field(None, title="Batch axis")


class SegmentationModelOutputSpecs(BaseModel):
    """
    Output specification for models that return segmentation scores.
    """

    class_names: Optional[List[str]] = Field(None, title="Class Names")
    output_format: Union[DictOutputFormat, SingleOutputFormat] = Field(
        ..., title="Output Format"
    )
    dimensions: SegmentationScoreDimensionsModel
    name: Literal["SegmentationOutput"] = Field(
        "SegmentationOutput", title="Segmentation"
    )


class ClassificationScoreDimensionsModel(BaseModel):
    """
    Classification Output has class dimension.
    """

    class_: OutputDimensionModel = Field(..., title="Class axis")
    batch: Optional[OutputDimensionModel] = Field(None, title="Batch axis")


class ClassificationModelOutputSpecs(BaseModel):
    """
    Output specification for models that return classification scores.
    """

    class_names: Optional[List[str]] = Field(None, title="Class Names")
    output_format: Union[DictOutputFormat, SingleOutputFormat] = Field(
        ..., title="Output Format"
    )
    dimensions: ClassificationScoreDimensionsModel
    name: Literal["ClassificationOutput"] = Field(
        "ClassificationOutput", title="Classification"
    )


class MLModelContextSpec(BaseModel):
    """
    ML Model Context model.
    """

    input_specification: Union[
        GrayScaleImageInputSpecs, ColorImageInputSpecs, NgramInputSpecs
    ] = Field(..., title="Input Specification")
    output_specification: Union[
        SegmentationModelOutputSpecs, ClassificationModelOutputSpecs
    ] = Field(..., title="Output Specification")


class MLModelResponse(BaseModel):
    """
    MLModel response model.
    """

    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    versions: List[MLModelVersionResponse] = Field(..., title="Versions")
    framework: FrameworkType
    context: MLModelContextSpec


class ListMLModelResponse(BaseModel):
    """
    List MLModel response model.
    """

    ml_models: List[MLModelResponse] = Field(..., title="Ml Models")


class TargetClassInput(BaseModel):
    """
    Union of str/int used as an input.
    """

    name: Literal["TargetClassInput"] = Field(
        "TargetClassInput",
        description=(
            "Specifies the target class used by an algorithm either by `index` (an"
            " integer value starting with 0) or by taking the argmax of the model"
            " prediction."
        ),
        title="Target Class",
    )
    value: Union[int, Literal["argmax"]] = Field(..., title="Value")


class IdentifierInput(BaseModel):
    """
    An entity identifier.
    """

    name: Literal["IdentifierInput"] = Field(
        "IdentifierInput",
        description='Identifier (ID) for a resource such as "Dataset" and "Pipeline".',
        title="Resource ID",
    )
    value: int = Field(..., title="Value")


class UserProvidedContext(BaseModel):
    pipeline_node_id: int = Field(..., title="Pipeline Node Id")
    context_name: str = Field(..., title="Context Name")
    value: Union[TargetClassInput, IdentifierInput] = Field(..., title="Value")


class CreatePipelineRunRequest(BaseModel):
    pipeline_id: int = Field(..., title="Pipeline Id")
    context: List[UserProvidedContext] = Field(..., title="Context")


class PipelineRunState(Enum):
    """
    Life cycle of a pipeline run.
    """

    PENDING = "PENDING"
    STOPPED = "STOPPED"
    RUNNING = "RUNNING"
    SUCCESS = "SUCCESS"
    FAILED = "FAILED"


class PipelineRunNodeResponse(BaseModel):
    id: int = Field(..., title="Id")
    state: PipelineRunState


class NamedEntity(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")


class PipelineRunResponse(BaseModel):
    id: int = Field(..., title="Id")
    nodes: List[PipelineRunNodeResponse] = Field(..., title="Nodes")
    ml_model: Optional[NamedEntity] = None
    ml_model_version: Optional[NamedEntity] = None
    dataset: Optional[NamedEntity] = None
    subset: Optional[NamedEntity] = None
    pipeline: Optional[NamedEntity] = None


class PipelineRunListResponse(BaseModel):
    pipeline_runs: List[PipelineRunResponse] = Field(..., title="Pipeline Runs")


class RequiredContextDescription(BaseModel):
    pipeline_node_id: int = Field(..., title="Pipeline Node Id")
    context_name: str = Field(..., title="Context Name")
    context_type: Dict[str, Any] = Field(..., title="Context Type")


class RequiredContextResponse(BaseModel):
    items: List[RequiredContextDescription] = Field(..., title="Items")


class ReportMethod(BaseModel):
    method_name: str = Field(..., title="Method Name")
    param_string: str = Field(..., title="Param String")
    pipeline_node_id: int = Field(..., title="Pipeline Node Id")


class ReportAverageRow(BaseModel):
    method: ReportMethod
    metric: ReportMethod
    metric_value: float = Field(..., title="Metric Value")


class ReportObservation(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    thumbnail_url: str = Field(..., title="Thumbnail Url")


class TabularReport(BaseModel):
    rows: List[ReportAverageRow] = Field(..., title="Rows")
    observations: List[ReportObservation] = Field(..., title="Observations")
    methods: List[ReportMethod] = Field(..., title="Methods")


class SubsetResponse(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    observation_ids: List[int] = Field(..., title="Observation Ids")


class _ModelCompilation(BaseModel):
    ml_model_version_response: MLModelVersionResponse
    list_ml_model_version_response: ListMLModelVersionResponse
    ml_model_response: MLModelResponse
    list_ml_model_response: ListMLModelResponse
    create_pipeline_run_request: CreatePipelineRunRequest
    pipeline_run_response: PipelineRunResponse
    pipeline_run_list_response: PipelineRunListResponse
    required_context_response: RequiredContextResponse
    tabular_report: TabularReport
    subset_response: SubsetResponse
