/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iot from 'aws-cdk-lib/aws-iot';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * @summary The properties for the IotToKinesisFirehoseToS3 Construct
 */
export interface IotToKinesisStreamsProps {
    /**
     * User provided CfnTopicRuleProps to override the defaults.
     *
     * @default - Default props are used
     */
    readonly iotTopicRuleProps: iot.CfnTopicRuleProps;
    /**
     * Existing instance of Kinesis Stream object, providing both this and KinesisStreamProps will cause an error.
     *
     * @default - Default props are used
     */
    readonly existingStreamObj?: kinesis.Stream;
    /**
     * User provided props to override the default props for the Kinesis Stream.
     *
     * @default - Default props are used
     */
    readonly kinesisStreamProps?: kinesis.StreamProps | any;
    /**
     * Whether to create recommended CloudWatch alarms.
     *
     * @default - Alarms are created
     */
    readonly createCloudWatchAlarms?: boolean;
}
export declare class IotToKinesisStreams extends Construct {
    readonly iotTopicRule: iot.CfnTopicRule;
    readonly kinesisStream: kinesis.Stream;
    readonly cloudwatchAlarms?: cloudwatch.Alarm[];
    readonly iotActionsRole: iam.Role;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the IotToKinesisFirehoseToS3 class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: IotToKinesisStreamsProps);
}
