from enum import Enum


class PrivilegeTypes(Enum):  # EnumDSSXMLPrivilegeTypes
    """
    This interface defines the enumeration constants used to specify the DSS privilege types.
    """

    Reserved = 0  # DssXmlPrivilegesReserved Reserved for future use.
    CreateAppObj = 1  # DssXmlPrivilegesCreateAppObj Specifies a DSS privilege to allow the user to create application objects.
    CreateConfigObj = 2  # DssXmlPrivilegesCreateConfigObj Specifies a DSS privilege to allow the user to create configuration objects.
    CreateSchemaObj = 3  # DssXmlPrivilegesCreateSchemaObj Specifies a DSS privilege to allow the user to create schema objects.
    ScheduleRequest = 4  # DssXmlPrivilegesScheduleRequest Specifies a DSS privilege to allow the user to schedule a report to run.
    UseArchitect = 5  # DssXmlPrivilegesUseArchitect Specifies a DSS privilege to allow the user to use architect functions.
    WebReportDetails = 6  # DssXmlPrivilegesWebReportDetails Specifies a DSS privilege to allow the user to view report details on the Web.
    UseServerAdmin = 7  # DssXmlPrivilegesUseServerAdmin Specifies a DSS privilege to give the user access to all the administrative functionality.
    UseMetricEditor = 8  # DssXmlPrivilegesUseMetricEditor Specifies a DSS privilege to allow the user to use the metric editor.
    UseFilterEditor = 9  # DssXmlPrivilegesUseFilterEditor Specifies a DSS privilege to allow the user to use the filter editor.
    UseTemplateEditor = 10  # DssXmlPrivilegesUseTemplateEditor Specifies a DSS privilege to allow the user to use the template editor.
    UseReportEditor = 11  # DssXmlPrivilegesUseReportEditor Specifies a DSS privilege to allow the user to use the report editor.
    UseConsolidationEditor = 12  # DssXmlPrivilegesUseConsolidationEditor Specifies a DSS privilege to allow the user to use the consolidation editor.
    UseCustomGroupEditor = 13  # DssXmlPrivilegesUseCustomGroupEditor Specifies a DSS privilege to allow the user to use the custom group editor.
    UseDocumentEditor = 14  # DssXmlPrivilegesUseDocumentEditor Specifies a DSS privilege to allow the user to use the document editor.
    UsePromptEditor = 15  # DssXmlPrivilegesUsePromptEditor Specifies a DSS privilege to allow the user to use the prompt editor.
    BypassAccessChecks = 16  # DssXmlPrivilegesBypassAccessChecks Specifies a DSS privilege to allow the user to override all objects access validation.
    WebAdministrator = 17  # DssXmlPrivilegesWebAdministrator Specifies a DSS privilege to allow the user to access the web administrator page.
    WebUser = 18  # DssXmlPrivilegesWebUser Specifies a DSS privilege to allow the user to connect to MicroStrategy 7.0 using the Web interface.
    WebViewHistoryList = 19  # DssXmlPrivilegesWebViewHistoryList Specifies a DSS privilege to allow the user to view the History List on the Web.
    WebReportManipulations = 20  # DssXmlPrivilegesWebReportManipulations Specifies a DSS privilege to allow the user to perform report manipulation on the Web.
    WebCreateNewReport = 21  # DssXmlPrivilegesWebCreateNewReport Specifies a DSS privilege to give the user access to Create Report Page on the Web.
    WebObjectSearch = 22  # DssXmlPrivilegesWebObjectSearch Specifies a DSS privilege to allow the user to search on objects on the Web.
    WebChangeUserOptions = 23  # DssXmlPrivilegesWebChangeUserOptions Specifies a DSS privilege to allow the user to change User Options List on the Web.
    WebSaveReport = 24  # DssXmlPrivilegesWebSaveReport Specifies a DSS privilege to allow the user to save reports List on the Web.
    WebAdvancedDrilling = 25  # DssXmlPrivilegesWebAdvancedDrilling Specifies a DSS privilege to allow the user to do advanced drilling on reports on the Web.
    WebExport = 26  # DssXmlPrivilegesWebExport Specifies a DSS privilege to allow the user to export on the Web.
    WebPrintMode = 27  # DssXmlPrivilegesWebPrintMode Specifies a DSS privilege to give the user access to printing capabilities on the Web.
    WebManageObjects = 28  # DssXmlPrivilegesWebManageObjects Specifies a DSS privilege to allow the user to manage objects on the Web.
    WebPublish = 29  # DssXmlPrivilegesWebPublish Specifies a DSS privilege to allow the user to publish on the Web.
    UseServerCache = 30  # DssXmlPrivilegesUseServerCache Specifies a DSS privilege to allow the user to use the server cache on the Web.
    WebReportSQL = 31  # DssXmlPrivilegesWebReportSQL Specifies a DSS privilege to allow the user to view the SQL of reports on the Web.
    Reserved2 = 32  # DssXmlPrivilegesReserved2 Reserved - necessary for backward compatibility reasons.
    CreateDatamart = 33  # DssXmlPrivilegesCreateDatamart Specifies a DSS privilege to allow the user to create a datamart.
    UseDatamartEditor = 34  # DssXmlPrivilegesUseDatamartEditor Specifies a DSS privilege to allow the user to use the datamart editor
    UseObjectManager = 35  # DssXmlPrivilegesUseObjectManager Specifies a DSS privilege to allow the user to use the object manager.
    WebAddToHistoryList = 36  # DssXmlPrivilegesWebAddToHistoryList Specifies a DSS privilege to allow the user to add to the history list on the Web.
    WebChangeViewMode = 37  # DssXmlPrivilegesWebChangeViewMode Specifies a DSS privilege to change the view mode on the Web.
    WebNormalDrilling = 38  # DssXmlPrivilegesWebNormalDrilling Specifies a DSS privilege to allow the user to perform normal drilling on the Web.
    WebDrillOnMetrics = 39  # DssXmlPrivilegesWebDrillOnMetrics Specifies a DSS privilege to allow the user to drill on metrics on the Web.
    WebFormatGridAndGraph = 40  # DssXmlPrivilegesWebFormatGridAndGraph Specifies a DSS privilege to allow the user to use the grid and graph format.
    WebScheduleReport = 41  # DssXmlPrivilegesWebScheduleReport Specifies a DSS privilege to allow the user to schedule a report.
    WebSimultaneousExecution = 42  # DssXmlPrivilegesWebSimultaneousExecution Specifies a DSS privilege to allow the user to perform simultaneous execution over the web.
    WebSwitchPageByElements = 43  # DssXmlPrivilegesWebSwitchPageByElements Specifies a DSS privilege to allow the user to switch page-by elements.
    WebSort = 44  # DssXmlPrivilegesWebSort Specifies a DSS privilege to allow the user to sort on the web.
    UseVLDBPropertyEditor = 45  # DssXmlPrivilegesUseVLDBPropertyEditor Specifies a DSS privilege to allow the user to use the VLDB Property Editor.
    WebSaveTemplatesAndFilters = 46  # DssXmlPrivilegesWebSaveTemplatesAndFilters Specifies a DSS privilege to allow the user to save templates and filters over the web.
    WebFilterOnSelections = 47  # DssXmlPrivilegesWebFilterOnSelections Specifies a DSS privilege to allow the user to filter on selections over the web.
    ScheduleAdministration = 48  # DssXmlPrivilegesScheduleAdministration Specifies a DSS privilege to allow the user to administer schedules.
    WebScheduleEMail = 49  # DssXmlPrivilegesWebScheduleEMail Specifies a DSS privilege to allow the user to schedule e-mails.
    UseUserManager = 50  # DssXmlPrivilegesUseUserManager Specifies a DSS privilege to allow the user to manage users.
    UseJobMonitor = 51  # DssXmlPrivilegesUseJobMonitor Specifies a DSS privilege to allow the user to use job monitor.
    UseUserConnectionMonitor = 52  # DssXmlPrivilegesUseUserConnectionMonitor Specifies a DSS privilege to allow the user to use user connection maonitor.
    UseDatabaseConnectionMonitor = 53  # DssXmlPrivilegesUseDatabaseConnectionMonitor Specifies a DSS privilege to allow the user to use database connection monitor.
    UseScheduleMonitor = 54  # DssXmlPrivilegesUseScheduleMonitor Specifies a DSS privilege to allow the user to use schedule monitor.
    UseCacheMonitor = 55  # DssXmlPrivilegesUseCacheMonitor Specifies a DSS privilege to allow the user to use cache monitor.
    UseClusterMonitor = 56  # DssXmlPrivilegesUseClusterMonitor Specifies a DSS privilege to allow the user to use cluster monitor.
    UseDatabaseInstanceManager = 57  # DssXmlPrivilegesUseDatabaseInstanceManager Specifies a DSS privilege to allow the user to use database instance manager.
    UseScheduleManager = 58  # DssXmlPrivilegesUseScheduleManager Specifies a DSS privilege to allow the user to use schedule manager.
    UseProjectMonitor = 59  # DssXmlPrivilegesUseProjectMonitor Specifies a DSS privilege to allow the user to use project monitor.
    WebSendNow = 60  # DssXmlPrivilegesWebSendNow Specifies a DSS privilege to allow the user to use send now feature.
    ModifySchemaObjects = 61  # DssXmlPrivilegesModifySchemaObjects Specifies a DSS privilege to allow the user to modify schema objects.
    ViewETLInformation = 62  # DssXmlPrivilegesViewETLInformation Specifies a DSS privilege to allow the user to view ETL information.
    UseReportObjectsWindow = 63  # DssXmlPrivilegesUseReportObjectsWindow Specifies a DSS privilege to allow the user to use report objects windo.
    UseThresholdsEditor = 64  # DssXmlPrivilegesUseThresholdsEditor Specifies a DSS privilege to allow the user to use thresholds editor.
    UseFormattingEditor = 65  # DssXmlPrivilegesUseFormattingEditor Specifies a DSS privilege to allow the user to use formatting editor.
    SaveCustomAutoStyle = 66  # DssXmlPrivilegesSaveCustomAutoStyle Specifies a DSS privilege to allow the user to save custom atostyle.
    UseReportFilterEditor = 67  # DssXmlPrivilegesUseReportFilterEditor Specifies a DSS privilege to allow the user to use report filter editor.
    CreateDerivedMetrics = 68  # DssXmlPrivilegesCreateDerivedMetrics Specifies a DSS privilege to allow the user to create derived metrics.
    ModifySubtotals = 69  # DssXmlPrivilegesModifySubtotals Specifies a DSS privilege to allow the user to modify subtotals.
    ModifyReportObjectList = 70  # DssXmlPrivilegesModifyReportObjectList Specifies a DSS privilege to allow the user to modify report object list.
    WebCreateDerivedMetrics = 71  # DssXmlPrivilegesWebCreateDerivedMetrics Specifies a DSS privilege to allow the user to create derived metrics in Web.
    WebModifySubtotals = 72  # DssXmlPrivilegesWebModifySubtotals Specifies a DSS privilege to allow the user to modify subtotals in Web.
    WebModifyReportList = 73  # DssXmlPrivilegesWebModifyReportList Specifies a DSS privilege to allow the user to modify report list in Web.
    WebUseReportObjectsWindow = 74  # DssXmlPrivilegesWebUseReportObjectsWindow Specifies a DSS privilege to allow the user to use report object window in Web.
    WebUseReportFilterEditor = 75  # DssXmlPrivilegesWebUseReportFilterEditor Specifies a DSS privilege to allow the user to use report filter editor in Web.
    WebUseDesignMode = 76  # DssXmlPrivilegesWebUseDesignMode Specifies a DSS privilege to allow the user to use design mode in Web.
    WebAliasObjects = 77  # DssXmlPrivilegesWebAliasObjects Specifies a DSS privilege to allow the user to change object aliases in Web.
    WebConfigureToolbars = 78  # DssXmlPrivilegesWebConfigureToolbars Specifies a DSS privilege to allow the user to configure toolbars in Web.
    WebUseQueryFilterEditor = 79  # DssXmlPrivilegesWebUseQueryFilterEditor Specifies a DSS privilege to allow the user to use query filter editor in Web.
    WebReExecuteReportAgainstWH = 80  # DssXmlPrivilegesWebReExecuteReportAgainstWH Specifies a DSS privilege to allow the user to re-execute reports in Web.
    ChooseAttributeFormDisplay = 81  # DssXmlPrivilegesChooseAttributeFormDisplay Specifies a DSS privilege to allow the user to choose attribute display.
    UseHistoryList = 82  # DssXmlPrivilegesUseHistoryList Specifies a DSS privilege to allow the user to use history list.
    ConfigureToolbars = 83  # DssXmlPrivilegesConfigureToolbars Specifies a DSS privilege to allow the user to configure toolbars.
    ChangeUserPreferences = 84  # DssXmlPrivilegesChangeUserPreferences Specifies a DSS privilege to allow the user to change user preferences.
    UseReportDataOptions = 85  # DssXmlPrivilegesUseReportDataOptions Specifies a DSS privilege to allow the user to use report data options.
    UseDataExplorer = 86  # DssXmlPrivilegesUseDataExplorer Specifies a DSS privilege to allow the user to use data explorer.
    FormatGraph = 87  # DssXmlPrivilegesFormatGraph Specifies a DSS privilege to allow the user to format graph.
    ModifySorting = 88  # DssXmlPrivilegesModifySorting Specifies a DSS privilege to allow the user to modify sorting.
    ViewSQL = 89  # DssXmlPrivilegesViewSQL Specifies a DSS privilege to allow the user to view SQL.
    CreateNewFolder = 90  # DssXmlPrivilegesCreateNewFolder Specifies a DSS privilege to allow the user to create new folder.
    PivotReport = 91  # DssXmlPrivilegesPivotReport Specifies a DSS privilege to allow the user to privot report.
    UseDesignMode = 92  # DssXmlPrivilegesUseDesignMode Specifies a DSS privilege to allow the user to use design mode.
    AliasObjects = 93  # DssXmlPrivilegesAliasObjects Specifies a DSS privilege to allow the user to change object aliases.
    UseGridOptions = 94  # DssXmlPrivilegesUseGridOptions Specifies a DSS privilege to allow the user to use grid options.
    UseSearchEditor = 95  # DssXmlPrivilegesUseSearchEditor Specifies a DSS privilege to allow the user to use search editor.
    ReExecuteReportAgainstWH = 96  # DssXmlPrivilegesReExecuteReportAgainstWH Specifies a DSS privilege to allow the user to re-execute reports.
    UseDrillMapEditor = 97  # DssXmlPrivilegesUseDrillMapEditor Specifies a DSS privilege to allow the user to use drill map editor.
    SendToEMail = 98  # DssXmlPrivilegesSendToEMail Specifies a DSS privilege to allow the user to send reports to e-mail.
    UseFunctionPlugInEditor = 99  # DssXmlPrivilegesUseFunctionPlugInEditor Specifies a DSS privilege to allow the user to use function plug in editor.
    WebSimpleGraphFormatting = 100  # DssXmlPrivilegesWebSimpleGraphFormatting Specifies a DSS privilege to allow the user to use simple graph formatting in Web.
    WebUseLockedHeaders = 101  # DssXmlPrivilegesWebUseLockedHeaders Specifies a DSS privilege to allow the user to use locked headers in Web.
    WebSetColumnWidths = 102  # DssXmlPrivilegesWebSetColumnWidths Specifies a DSS privilege to allow the user to set column widhths in Web.
    UseSecurityFilterManager = 103  # DssXmlPrivilegesUseSecurityFilterManager Specifies a DSS privilege to allow the user to use security filter manager.
    UseProjectStatusEditor = 104  # DssXmlPrivilegesUseProjectStatusEditor Specifies a DSS privilege to allow the user to use project status editor.
    UseProjectDocumentation = 105  # DssXmlPrivilegesUseProjectDocumentation Specifies a DSS privilege to allow the user to use project documentation.
    WebExecuteDatamartReport = 106  # DssXmlPrivilegesWebExecuteDatamartReport Specifies a DSS privilege to allow the user to execute datamart reports in Web.
    UseSubtotalEditor = 107  # DssXmlPrivilegesUseSubtotalEditor Specifies a DSS privilege to allow the user to use subtotal editor.
    UseFindAndReplaceDialog = 108  # DssXmlPrivilegesUseFindAndReplaceDialog Specifies a DSS privilege to allow the user to use find and replace dialog.
    UseCommandManager = 109  # DssXmlPrivilegesUseCommandManager Specifies a DSS privilege to allow the user to use command manager.
    UseRWDocumentEditor = 110  # DssXmlPrivilegesUseRWDocumentEditor Specifies a DSS privilege to allow the user to use RW document editor.
    ExecuteRWDocument = 111  # DssXmlPrivilegesExecuteRWDocument Specifies a DSS privilege to allow the user to execute RW documents.
    WebExecuteRWDocument = 112  # DssXmlPrivilegesWebExecuteRWDocument Specifies a DSS privilege to allow the user to execute RW documents in Web.
    UseOfficeIntelligence = 113  # DssXmlPrivilegesUseOfficeIntelligence Specifies a DSS privilege to allow the user to use office intelligence.
    WebCreateEmailAddress = 114  # DssXmlPrivilegesWebCreateEmailAddress Specifies a DSS privilege to allow the user to create e-mail addresses in Web.
    WebPrintNow = 115  # DssXmlPrivilegesWebPrintNow Specifies a DSS privilege to allow the user to use print now feature in Web.
    WebScheduledPrinting = 116  # DssXmlPrivilegesWebScheduledPrinting Specifies a DSS privilege to allow the user to shedule printing in Web.
    WebCreatePrintLocation = 117  # DssXmlPrivilegesWebCreatePrintLocation Specifies a DSS privilege to allow the user to create print locations in Web.
    WebExportToFileNow = 118  # DssXmlPrivilegesWebExportToFileNow Specifies a DSS privilege to allow the user to use export to file now feature in Web.
    WebScheduledExportToFile = 119  # DssXmlPrivilegesWebScheduledExportToFile Specifies a DSS privilege to allow the user to shedule export to file in Web.
    WebCreateFileLocation = 120  # DssXmlPrivilegesWebCreateFileLocation Specifies a DSS privilege to allow the user to create file locations in Web.
    ServerMonitoring = 121  # DssXmlPrivilegesServerMonitoring Specifies a DSS privilege to allow the user to monitor servers.
    DefineFreeformSQLReport = 122  # DssXmlPrivilegesDefineFreeformSQLReport Specifies a DSS privilege to allow the user to define freeform SQL reports.
    DefineOLAPCubeReport = 123  # DssXmlPrivilegesDefineOLAPCubeReport Specifies a DSS privilege to allow the user to define OLAP cube reports.
    ImportOLAPCube = 124  # DssXmlPrivilegesImportOLAPCube Specifies a DSS privilege to allow the user to import OLAP cubes.
    WebDocumentDesign = 125  # DssXmlPrivilegesWebDocumentDesign Specifies a DSS privilege to allow the user to design documents in Web.
    WebManageDocumentDatasets = 126  # DssXmlPrivilegesWebManageDocumentDatasets Specifies a DSS privilege to allow the user to manage document data sets in Web.
    WebModifyUnitInGridInDocument = 127  # DssXmlPrivilegesWebModifyUnitInGridInDocument Specifies a DSS privilege to allow the user to modify grid levels in documents in Web.
    WebChooseAttributeFormDisplay = 128  # DssXmlPrivilegesWebChooseAttributeFormDisplay Specifies a DSS privilege to allow the user to set attribute form display in Web.
    WebExecuteBulkExport = 129  # DssXmlPrivilegesWebExecuteBulkExport Specifies a DSS privilege to allow the user to execute bulk export reports in Web.
    WebNumberFormatting = 130  # DssXmlPrivilegesWebNumberFormatting Specifies a DSS privilege to allow the user to perform number formatting in Web.
    UseDesktop = 131  # DssXmlPrivilegesUseDesktop Specifies a DSS privilege to allow the user to use desktop.
    CreateShortcut = 132  # DssXmlPrivilegesCreateShortcut Specifies a DSS privilege to allow the user to create a shortcut.
    WebEnableMMTAccess = 133  # DssXmlPrivilegesWebEnableMMTAccess Specifies a DSS privilege to allow the user MMT access in Web.
    DrillWithIntelligentCube = 134  # DssXmlPrivilegesDrillWithIntelligentCube Specifies a DSS privilege to allow the user to drill with an intelligent cube.
    DefineQueryBuilderReport = 135  # DssXmlPrivilegesDefineQueryBuilderReport Specifies a DSS privilege to allow the user to create a query builder report in Desktop.
    WebDefineQueryBuilderReport = 136  # DssXmlPrivilegesWebDefineQueryBuilderReport Specifies a DSS privilege to allow the user to create a query builder report in Web.
    UseMstrMobile = 137  # DssXmlPrivilegesUseMstrMobile None
    MobileViewDocument = 138  # DssXmlPrivilegesMobileViewDocument None
    UseIntegrityManager = 139  # DssXmlPrivilegesUseIntegrityManager None
    CacheAdministration = 140  # DssXmlPrivilegesCacheAdministration Specifies a DSS privilege to allow the user to view the detail information of all  report caches of a specific project in the cluster.
    UseInboxMonitor = 141  # DssXmlPrivilegesUseInboxMonitor Specifies a DSS privilege to allow the user to view the detail information of all  history list messages in a specific project in the cluster.
    InboxAdministration = 142  # DssXmlPrivilegesInboxAdministration Specifies a DSS privilege to allow the user to delete other users history list messages in a specific project in the cluster.
    UseCubeMonitor = 143  # DssXmlPrivilegesUseCubeMonitor Specifies a DSS privilege to allow the user to view the detail information of all  cubes in a specific project in the cluster.
    CubeAdministration = 144  # DssXmlPrivilegesCubeAdministration Specifies a DSS privilege to allow the user to activate/de-activate,  delete and refresh cubes of a specific project in the cluster.
    FireEvent = 145  # DssXmlPrivilegesFireEvent Specifies a DSS privilege to allow the user to fire events on a  specific node of the cluster.
    UseTransmitterDeviceManager = 146  # DssXmlPrivilegesUseTransmitterDeviceManager Specifies a DSS privilege to allow the user to create  new transmitters and devices as well as to modify existing  transmitters and devices.
    UseContactManager = 147  # DssXmlPrivilegesUseContactManager Specifies a DSS privilege to allow the user to create, alter and delete  contacts and contact collections as well ascreate, edit and remove  addresses of users and contacts.
    UseSecurityRoleManager = 148  # DssXmlPrivilegesUseSecurityRoleManager Specifies a DSS privilege to allow the user to create new  security roles as well as to modify existing security roles.
    AssignSecurityRoles = 149  # DssXmlPrivilegesAssignSecurityRoles Specifies a DSS privilege to allow the user to grant  (or revoke) a security role to a user for a specific project.
    ConfigureContactDataProfile = 150  # DssXmlPrivilegesConfigureContactDataProfile Specifies a DSS privilege to allow the user to link and unlink contacts  to users for the purpose of defining data security.
    ResetUserPasswords = 151  # DssXmlPrivilegesResetUserPasswords Specifies a DSS privilege to allow the user to change the passwords  of other users.
    LinkToExternalAccounts = 152  # DssXmlPrivilegesLinkToExternalAccounts Specifies a DSS privilege to allow the user to link users to  external accounts (NT, database, LDAP) as well as link groups  to external groups (LDAP).
    GrantPrivilege = 153  # DssXmlPrivilegesGrantPrivilege Specifies a DSS privilege to allow the user to to define the  privileges of users and groups at the server level.
    ConfigureGroupMembership = 154  # DssXmlPrivilegesConfigureGroupMembership Specifies a DSS privilege to allow the user to define group  memberships i.e. to place/remove a user into groups or  to add/remove users to a group.
    UseDatabaseLoginManager = 155  # DssXmlPrivilegesUseDatabaseLoginManager Specifies a DSS privilege to allow the user to create new  database logins as well as to modify existing database logins.
    DefineSecurityFilter = 156  # DssXmlPrivilegesDefineSecurityFilter Specifies a DSS privilege to allow the user to create new  security filters as well as to modify existing security filters.
    ClusterAdministration = 157  # DssXmlPrivilegesClusterAdministration Specifies a DSS privilege to allow the user to activate/de-activate,  delete and refresh cubes of a specific project in the cluster.
    LoadProject = 158  # DssXmlPrivilegesLoadProject Specifies a DSS privilege to allow the user to user to load and  unload projects on a server.
    IdleProject = 159  # DssXmlPrivilegesIdleProject Specifies a DSS privilege to allow the user to idle  and resume projects on a server.
    DefineViewReport = 160  # DssXmlPrivilegesDefineViewReport Specifies a DSS privilege to allow the user to create a view report (use an Intelligent Cube as a datasource) in desktop.
    UseCubeReportEditor = 161  # DssXmlPrivilegesUseCubeReportEditor Specifies a DSS privilege to allow the user to use the Cube Report Editor.
    ExecuteCubeReport = 162  # DssXmlPrivilegesExecuteCubeReport Specifies a DSS privilege to allow the user to execute a cube report in desktop.
    WebDefineViewReport = 163  # DssXmlPrivilegesWebDefineViewReport Specifies a DSS privilege to allow the user to create a view report (use an Intelligent Cube as a datasource) in web.
    WebExecuteCubeReport = 164  # DssXmlPrivilegesWebExecuteCubeReport Specifies a DSS privilege to allow the user to execute a cube report in web or office.
    ConfigureServerBasic = 165  # DssXmlPrivilegesConfigureServerBasic None
    ConfigureStatistics = 166  # DssXmlPrivilegesConfigureStatistics None
    ConfigureSecurity = 167  # DssXmlPrivilegesConfigureSecurity None
    ConfigureInbox = 168  # DssXmlPrivilegesConfigureInbox None
    ConfigureGoverning = 169  # DssXmlPrivilegesConfigureGoverning None
    ConfigureCaches = 170  # DssXmlPrivilegesConfigureCaches None
    ConfigureProjectBasic = 171  # DssXmlPrivilegesConfigureProjectBasic None
    ConfigureConnectionMap = 172  # DssXmlPrivilegesConfigureConnectionMap None
    ConfigureProjectDataSource = 173  # DssXmlPrivilegesConfigureProjectDataSource None
    EnableUser = 174  # DssXmlPrivilegesEnableUser None
    ConfigureSubscriptionSettings = 175  # DssXmlPrivilegesConfigureSubscriptionSettings None
    ConfigureAuditing = 176  # DssXmlPrivilegesConfigureAuditing None
    ConfigureLanguageSettings = 177  # DssXmlPrivilegesConfigureLanguageSettings None
    MonitorChangeJournal = 178  # DssXmlPrivilegesMonitorChangeJournal None
    UseBulkTranslationTool = 179  # DssXmlPrivilegesUseBulkTranslationTool None
    UseBulkExportEditor = 180  # DssXmlPrivilegesUseBulkExportEditor None
    JobAdministration = 181  # DssXmlPrivilegesJobAdministration Specifies a DSS privilege to allow the user to kill jobs for a specific project on the server.
    UserConnectionAdministration = 182  # DssXmlPrivilegesUserConnectionAdministration Specifies a DSS privilege to allow the user to user to disconnect user connections  for a specific project on a server.
    DatabaseConnectionAdministration = 183  # DssXmlPrivilegesDatabaseConnectionAdministration Specifies a DSS privilege to allow the user to user to view the detail information  of all user connections to a specific project on the server.
    DuplicateProject = 184  # DssXmlPrivilegesDuplicateProject None
    SubscribeOthers = 185  # DssXmlPrivilegesSubscribeOthers Specifies a DSS Privilege that controls whether a user can subscribe to other users/contacts/contact groups while creating a subscription.
    SubscribeToEmailAlert = 186  # DssXmlPrivilegesSubscribeToEmailAlert Specifies a DSS Privilege that controls whethere a user can create an alerting subscription.
    SendLinkInEmail = 187  # DssXmlPrivilegesSendLinkInEmail Specifies a DSS Privilege that controls whether a user can send a link to a report or document while subscribing to it.
    ExportToPDF = 188  # DssXmlPrivilegesExportToPDF Specifies a DSS privilege that controls whether a user can export to PDF.
    ExportToHTML = 189  # DssXmlPrivilegesExportToHTML Specifies a DSS privilege that controls whether a user can export to HTML.
    ExportToExcel = 190  # DssXmlPrivilegesExportToExcel Specifies a DSS privilege that controls whether a user can export to Excel.
    ExportToText = 191  # DssXmlPrivilegesExportToText Specifies a DSS privilege that controls whether a user can export to plain text, excel with plaintext or CSV format
    ExportToFlash = 192  # DssXmlPrivilegesExportToFlash Specifies a DSS privilege that controls whether a user can export to Flash.
    ViewNotes = 193  # DssXmlPrivilegesViewNotes Specifies a DSS privilege that controls whether a user can view the notes of a report or document.
    AddNotes = 194  # DssXmlPrivilegesAddNotes Specifies a DSS privilege that controls whether a user can add to the notes of a report or document.
    EditNotes = 195  # DssXmlPrivilegesEditNotes Specifies a DSS privilege that controls whether a user can edit a previous comment/note of a  report or document
    UseDistributionServices = 196  # DssXmlPrivilegesUseDistributionServices Specifies a DSS privilege that controls whether a recipient can receive a email/file/print subscriptions.  This privilege is enforced at run-time on the Intelligence Server.
    UseImmediateDelivery = 197  # DssXmlPrivilegesUseImmediateDelivery Specifies a DSS privilege that controls whether the 'send preview' option is seen in the subscription dialog. Applies to email/file/print and bulk export subscriptions.
    EnableAdministrationFromWeb = 198  # DssXmlPrivilegesEnableAdministrationFromWeb Specifies a DSS privilege that controls whether a user can access the administrator functionality from web.
    UseTranslationEditor = 199  # DssXmlPrivilegesUseTranslationEditor Specifies a DSS privilege that controls whether a user can use the translation editor.
    WebUsePromptEditor = 200  # DssXmlPrivilegesWebUsePromptEditor Specifies a DSS privilege that controls whether users can create/edit prompts from web.
    CreateHTMLContainer = 201  # DssXmlPrivilegesCreateHTMLContainer Specifies a DSS privilege that controls whether a user can create an HTML container  in a report writing document.
    ImportTableFromMultipleSources = 202  # DssXmlPrivilegesImportTableFromMultipleSources Specifies a DSS privilege that controls whether a user can import table from multiple sources.
    ExecuteMultipleSourceReport = 203  # DssXmlPrivilegesExecuteMultipleSourceReport Specifies a DSS privilege that controls whether a user can run a report which uses tables from multiple sources
    SavePersonalPromptAnswers = 204  # DssXmlPrivilegesSavePersonalPromptAnswers Allows the user to save and reuse personal prompt answers. Without this privilege, the options for saving and  loading personal answers on the prompt page, and the prompt-level properties related to Personal Answers in the  Prompt Editor are hidden
    WebDefineDerivedElements = 205  # DssXmlPrivilegesWebDefineDerivedElements Allows the user to create, edit and clear derived elements within a report and to use/load stand-alone  derived elements that have been created and saved by another user. Without this privilege the RMC options  (and any related toolbar buttons) for Create Group, Create Calculation, Clear Derived Elements, and Edit  Derived Elements should all be hidden
    WebUseBasicThresholdEditor = 206  # DssXmlPrivilegesWebUseBasicThresholdEditor Allows the web user to use simple threshold editor for Conditional formatting in Report Services.  Without this privilege, the user should not be able to use the Simple Conditional Formatting editor
    WebDashboardDesign = 207  # DssXmlPrivilegesWebDashboardDesign Allows the user to add a layout to a document using the Dashboard Templates. If the user has neither of these two  privileges, the option to Create Document and the options to Insert Layouts are hidden
    WebSaveDerivedElements = 208  # DssXmlPrivilegesWebSaveDerivedElements Allows the user to create, edit and clear derived elements within a report and to use/load  stand-alone derived elements and save the definition of a derived element as a stand-alone object.  Without this privilege the Save option in the derived elements editor is hidden
    WebUseAdvancedThresholdEditor = 209  # DssXmlPrivilegesWebUseAdvancedThresholdEditor Allows the web user to use the advanced threshold editor for Conditional formatting in Report Services.  Without this privilege, the user should not be able to use the Advanced Conditional Formatting editor
    WebEditReportLinks = 210  # DssXmlPrivilegesWebEditReportLinks Allows the user to create and edit Links for Reports and Grids, text fields and images in Documents.  Without this privilege the menu option for opening the Links editor should be hidden  Allows the user to change drill options for Reports and Grids/Graphs in Documents.  Without this privilege the Drilling section of the Report/Grid Options editor should be hidden  Can also be referred to as WebEditDrillingAndLinks
    DefineDerivedElements = 211  # DssXmlPrivilegesDefineDerivedElements Allows the user to create, edit and clear derived elements within a report and to use/load stand-alone  derived elements that have been created and saved by another user. Without this privilege the RMC options  (and any related toolbar buttons) for Create Group, Create Calculation, Clear Derived Elements, and Edit  Derived Elements should all be hidden
    DashboardDesign = 212  # DssXmlPrivilegesDashboardDesign Allows the user to insert a new layout into a document, rename, rearrange and delete layouts
    SaveDerivedElements = 213  # DssXmlPrivilegesSaveDerivedElements Allows the user to create, edit and clear derived elements within a report and to use/load  stand-alone derived elements and save the definition of a derived element as a stand-alone object.  Without this privilege the Save option in the derived elements editor is hidden
    EditReportLinks = 214  # DssXmlPrivilegesEditReportLinks Allow the user to create and edit Links for text fields and images in Documents.
    WebEditNotes = 215  # DssXmlPrivilegesWebEditNotes Allows the user to see the Notes panel, add additional notes, and edit complete definition of notes
    DrillAndLink = 216  # DssXmlPrivilegesDrillAndLink Allows the user to use Links at runtime on Reports and on Grids, Text Fields and Images in Documents.  Without this privilege, the default Link should not be rendered on a Grid, text field or image, and the  Links option on the RMC menu should be hidden. (Desktop)
    WebDefineAdvancedReportOptions = 217  # DssXmlPrivilegesWebDefineAdvancedReportOptions Allows the user to set the available and default run and export modes for a Report.  Without this privilege, the Advanced Tab in the Report Options editor is hidden
    WebCreateHTMLContainer = 218  # DssXmlPrivilegesWebCreateHTMLContainer Allow the user to create and edit HTML containers in Documents
    UseOLAPServices = 219  # DssXmlPrivilegesUseOLAPServices Allows user to user OLAP Services.
    UseDynamicSourcing = 220  # DssXmlPrivilegesUseDynamicSourcing Dynamic Sourcing is a new feature of MicroStrategy 9 OLAP Services that automatically checks a report request, and sources data from a MicroStrategy Intelligent Cube wherever possible.
    UseSQLStatementsTab = 221  # DssXmlPrivilegesUseSQLStatementsTab This privilege will control access to the "SQL Statements" tab  in the Datamart and Bulk Export editors.
    WebUseCustomGroupEditor = 222  # DssXmlPrivilegesWebUseCustomGroupEditor Allows user to use custom group editor in web
    WebImportData = 223  # DssXmlPrivilegesWebImportData Allows user to access import data page
    WebImportDatabase = 224  # DssXmlPrivilegesWebImportDatabase Allows user to import data from database
    DefineTransactionReport = 225  # DssXmlPrivilegesDefineTransactionReport None
    WebConfigureTransaction = 226  # DssXmlPrivilegesWebConfigureTransaction None
    ExecuteTransaction = 227  # DssXmlPrivilegesExecuteTransaction None
    WebVisualExploration = 228  # DssXmlPrivilegesWebVisualExploration None
    UseObjectManagerReadOnly = 229  # DssXmlPrivilegesUseObjectManagerReadOnly None
    UseObjectManagerImportOnly = 230  # DssXmlPrivilegesUseObjectManagerImportOnly None
    UseTranslationEditorBypass = 231  # DssXmlPrivilegesUseTranslationEditorBypass None
    WebUseObjectSharingEditor = 232  # DssXmlPrivilegesWebUseObjectSharingEditor None
    WebCreateAnalysis = 233  # DssXmlPrivilegesWebCreateAnalysis The ability to create an Analysis should be controlled by the privilege Web Create Analysis, along with the WebVisualExploration.
    WebSaveAnalysis = 234  # DssXmlPrivilegesWebSaveAnalysis The ability to Save an Analysis object should be controlled by the Web Save Analysis privilege, along with the WebVisualExploration
    PrintFromDevice = 235  # DssXmlPrivilegesPrintFromDevice None
    EmailScreenFromDevice = 236  # DssXmlPrivilegesEmailScreenFromDevice None
    WebCreateDynamicAddressList = 237  # DssXmlPrivilegesWebCreateDynamicAddressList None
    WebSubscribeDynamicAddressList = 238  # DssXmlPrivilegesWebSubscribeDynamicAddressList None
    UseSendPreviewNow = 239  # DssXmlPrivilegesUseSendPreviewNow None
    WebUseMetricEditor = 240  # DssXmlPrivilegesWebUseMetricEditor User should have Web Professional > 'Web use metric editor' privilege to use any of the standalone metric editors  in Web (Formula Editor, Simple Metric Editor & Function Wizard). Without this privilege, Metric objects should not  appear in the folder view, the 'Create Metric' link should not appear on the home page, the folder page toolbar,  or the folder page RMC menu.
    WebExecuteAnalysis = 241  # DssXmlPrivilegesWebExecuteAnalysis None
    MobileViewAnalysis = 242  # DssXmlPrivilegesMobileViewAnalysis None
    MobileSaveDocument = 243  # DssXmlPrivilegesMobileSaveDocument Reserved for future use
    MobileSaveAnalysis = 244  # DssXmlPrivilegesMobileSaveAnalysis None
    MobileCreateDocument = 245  # DssXmlPrivilegesMobileCreateDocument Reserved for future use
    MobileCreateAnalysis = 246  # DssXmlPrivilegesMobileCreateAnalysis Reserved for future use
    MobileSaveReport = 247  # DssXmlPrivilegesMobileSaveReport None
    MobilePublish = 248  # DssXmlPrivilegesMobilePublish None
    MobileEditAnalysis = 249  # DssXmlPrivilegesMobileEditAnalysis None
    WebScheduleFTP = 250  # DssXmlPrivilegesWebScheduleFTP Specifies a DSS privilege to allow the user to shedule export to FTP in Web.
    WebCreateFTPLocation = 251  # DssXmlPrivilegesWebCreateFTPLocation Specifies a DSS privilege to allow the user to create FTP locations in Web.
    AccessDataFromCloudApp = 252  # DssXmlPrivilegesAccessDataFromCloudApp Specifies a DSS privilege to allow the user to access data from cloud App.
    MonitorOperationManager = 253  # DssXmlPrivilegesMonitorOperationManager Specifies a DSS privilege to allow the user to monitor operation manager.
    AdministerOperationManager = 254  # DssXmlPrivilegesAdministerOperationManager Specifies a DSS privilege to allow the user to administer operation manager.
    ExportToMSTRFile = 255  # DssXmlPrivilegesExportToMSTRFile Specifies a DSS privilege to allow the user to export to MSTR file.
    ImportMSTRFile = 256  # DssXmlPrivilegesImportMSTRFile Specifies a DSS privilege to allow the user to import to MSTR file.
    SetOAuthParametersForCloudAppSources = 257  # DssXmlPrivilegesSetOAuthParametersForCloudAppSources Specifies a DSS privilege to allow the user to Set oAuth Parameters for Cloud App sources.
    UseMicrostrategyDesktop = 258  # DssXmlPrivilegesUseMicrostrategyDesktop Specifies a DSS privilege to allow the user to Use MicroStrategy Desktop
    MonitorQuickSearchIndices = 259  # DssXmlPrivilegesMonitorQuickSearchIndices Specifies a DSS privilege to allow the user to Monitor quick search indices
    CanCertify = 260  # DssXmlPrivilegesCanCertify Specifies a DSS privilege to allow the user to certify or decertify multiple published content
    PublishDossier = 261  # DssXmlPrivilegesPublishDossier Specifies a DSS privilege to allow the user to publish a dossier to other users or groups
    Maximum = 262  # DssXmlPrivilegesMaximum Specifies the current maximum privilege

PrivilegeTypesIDDict = {member.value: member for member in PrivilegeTypes}
