from enum import Enum


class ObjectType(Enum):
    # https://lw.microstrategy.com/msdz/MSDL/GARelease_Current/docs/ReferenceFiles/reference/com/microstrategy/webapi/EnumDSSXMLObjectTypes.html#DssXmlTypeLayer
    Generic = -2
    Unknown = -1
    AggMetric = 7
    Attribute = 12
    AttributeForm = 21
    Blob = 63
    Catalog = 24
    CatalogDefn = 25
    ChangeJournal = 66
    Column = 26
    Configuration = 36
    Consolidation = 47
    ConsolidationElement = 48
    DBConnection = 31
    DBLogin = 30
    DBMS = 57
    DBRole = 29
    Datamart = 41
    DatamartReport = 16
    DbTable = 53
    Device = 9
    Dimension = 14
    DocumentDefinition = 55
    DossierPersonalView = 73
    DrillMap = 56
    ExternalShortcut = 67
    ExternalShortcutTarget = 68
    Fact = 13
    FactGroup = 17
    Filter = 1
    Folder = 8
    Format = 23
    Function = 11
    FunctionPackageDefinition = 42
    Layer = 70
    Link = 52
    Locale = 45
    MDSecurityFilter = 58
    Metric = 4
    Monitor = 20
    ObjectTag = 65
    Palette = 71
    Project = 32
    Prompt = 10
    PromptAnswer = 59
    PromptAnswers = 60
    PropertySet = 28
    Reconciliation = 69
    ReportDefinition = 3
    Request = 37
    Reserved = 0
    ReservedLastOne = 74
    Resolution = 19
    Role = 43
    ScheduleEvent = 49
    ScheduleObject = 50
    ScheduleTrigger = 51
    Schema = 22
    Script = 38
    Search = 39
    SearchFolder = 40
    SecurityRole = 44
    ServerDef = 33
    Shortcut = 18
    Style = 6
    SubscriptionDevice = 9
    Table = 15
    TableSource = 54
    Template = 2
    Thresholds = 72
    Transmitter = 35


ObjectTypeIDDict = {member.value: member for member in ObjectType}


class ObjectSubType(Enum):
    # https://lw.microstrategy.com/msdz/MSDL/GARelease_Current/docs/ReferenceFiles/reference/com/microstrategy/webapi/EnumDSSXMLObjectSubTypes.html
    MetricTraining = 1028
    AggMetric = 1792
    Attribute = 3072
    AttributeAbstract = 3075
    AttributeForm = 5376
    AttributeRecursive = 3076
    AttributeRole = 3073
    AttributeTransformation = 3074
    BlobExcel = 16132
    BlobHTMLTemplate = 16133
    BlobImage = 16130
    BlobOther = 16129
    BlobProjectPackage = 16131
    BlobUnknown = 16128
    Catalog = 6144
    CatalogDefn = 6400
    ChangeJournal = 16896
    ChangeJournalSearch = 15872
    Column = 6656
    Configuration = 9216
    Consolidation = 12032
    ConsolidationElement = 12288
    ConsolidationManaged = 12033
    CustomGroup = 257
    DBConnection = 7936
    DBLogin = 7680
    DBMS = 14592
    DBRole = 7424
    DBRoleGenericDataConnector = 7430
    DBRoleOAuth = 7427
    DBTable = 13568
    DBTablePMT = 13569
    DashboardTemplate = 16384
    Datamart = 10496
    DatamartReport = 4096
    DerivedAttribute = 3077
    Device = 2304
    DimensionOrdered = 3586
    DimensionSystem = 3584
    DimensionUser = 3585
    DimensionUserHierarchy = 3587
    DocumentDefinition = 14080
    DocumentTheme = 14082
    DrillMap = 14336
    ExternalShortcutSnapshot = 17154
    ExternalShortcutTarget = 17408
    ExternalShortcutURL = 17153
    ExternalShortcutUnknown = 17152
    Fact = 3328
    FactGroup = 4352
    Filter = 256
    Flag = 16640
    Folder = 2048
    FormNormal = 5378
    FormSystem = 5377
    Format = 5888
    Function = 2816
    FunctionPackageDefinition = 10752
    GraphStyle = 15616
    InBox = 11520
    InBoxMsg = 11776
    Link = 13312
    MDSecurityFilter = 14848
    Metric = 1024
    MetricDMX = 1027
    MonitorDBConnections = 15107
    MonitorJobs = 15105
    MonitorPerformance = 15104
    MonitorUserConnections = 15106
    PaletteCustom = 17921
    PaletteSystem = 17920
    Project = 8192
    Prompt = 2560
    PromptAnswer = 15232
    PromptAnswerBigDecimal = 15243
    PromptAnswerBoolean = 15233
    PromptAnswerDate = 15237
    PromptAnswerDimty = 15242
    PromptAnswerDouble = 15236
    PromptAnswerElements = 15239
    PromptAnswerExpression = 15240
    PromptAnswerExpressionDraft = 15241
    PromptAnswerInt64 = 15244
    PromptAnswerLong = 15234
    PromptAnswerObjects = 15238
    PromptAnswerString = 15235
    PromptAnswers = 15360
    PromptBigDecimal = 2571
    PromptBoolean = 2561
    PromptDate = 2565
    PromptDimty = 2570
    PromptDouble = 2564
    PromptElements = 2567
    PromptExpression = 2568
    PromptExpressionDraft = 2569
    PromptLong = 2562
    PromptObjects = 2566
    PromptString = 2563
    PropertyGroup = 6912
    PropertySet = 7168
    Reconciliation = 17664
    ReportBase = 773
    ReportCube = 776
    ReportDatamart = 772
    ReportEmmaCube = 779
    ReportEmmaIncrementalRefresh = 780
    ReportEngine = 770
    ReportGraph = 769
    ReportGrid = 768
    ReportGridAndGraph = 774
    ReportIncrementalRefresh = 777
    ReportNonInteractive = 775
    ReportText = 771
    ReportTransaction = 778
    ReportWritingDocument = 14081
    Request = 9472
    Reserved = 0
    Resolution = 4864
    Role = 11008
    RoleTransformation = 11009
    ScheduleEvent = 12544
    ScheduleObject = 12800
    ScheduleTrigger = 13056
    Schema = 5632
    Search = 9984
    SearchFolder = 10240
    SecurityRole = 11264
    ServerDef = 8448
    Style = 1536
    SubscriptionAddress = 65281
    SubscriptionContact = 65282
    SubscriptionInstance = 65283
    SubtotalDefinition = 1025
    SystemSubtotal = 1026
    Table = 3840
    TablePartitionMD = 3841
    TablePartitionWH = 3842
    TableSource = 13824
    Template = 512
    Thresholds = 18432
    Transmitter = 8705
    Unknown = -1
    User = 8704


ObjectSubTypeIDDict = {member.value: member for member in ObjectSubType}