from marshmallow import (
    Schema,
    fields,
    validate,
)


class NewswireTableResourceSchema(Schema):
    not_blank = validate.Length(min=1, error='Field cannot be blank')

    id = fields.Integer(dump_only=True)
    news_id = fields.Integer(required=True)
    table_info = fields.String(allow_none=True)
    table_html_file_id = fields.Integer(allow_none=True)
    is_deleted = fields.Boolean(allow_none=True)
    updated_at = fields.DateTime()
