# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from datetime import datetime

# Local
from .core_texts import license
from .utils import multi_replace

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ Public methods ------------------------------------------------------------ #

def new_license(author_name: str) -> str:
    return multi_replace(
        license,
        {
            '[YEAR]': datetime.utcnow().year,
            '[AUTHOR_NAME]': author_name
        }
    )

# ---------------------------------------------------------------------------------------------------------------------------------------- #