"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveResourceName = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const variants_1 = require("./variants");
const assets_1 = require("../../generated/assets");
const utils_1 = require("../../utils");
/** @internal */
const RESOURCE_LOOKUP = Object.fromEntries([
    ...Object.keys(assets_1.AwsAsset.Resources).flatMap((key) => {
        return [
            // constant self lookup
            [key, key],
            // constant comparable
            [utils_1.normalizeComparisonString(key), key],
        ];
    }),
    ...Object.entries(variants_1.NORMALIZED_RESOURCE_VARIANTS).flatMap(([key, variants]) => {
        if (variants == null)
            return [];
        return variants.map((variant) => [utils_1.normalizeComparisonString(variant), key]);
    }),
]);
/**
 * Resolve resource name value to asset based service key.
 * @internal
 */
function resolveResourceName(value, service) {
    // constant lookup first for perf
    const comparableValue = utils_1.normalizeComparisonString(value);
    if (comparableValue in RESOURCE_LOOKUP) {
        return RESOURCE_LOOKUP[comparableValue];
    }
    if (service) {
        const servicePrefixed = `${utils_1.normalizeComparisonString(service)}${comparableValue}`;
        if (servicePrefixed in RESOURCE_LOOKUP) {
            const resourceName = RESOURCE_LOOKUP[servicePrefixed];
            RESOURCE_LOOKUP[comparableValue] = resourceName;
            return resourceName;
        }
    }
    throw new Error(`Failed to resolve resourceName ${value} [${service}] (${comparableValue})`);
}
exports.resolveResourceName = resolveResourceName;
//# sourceMappingURL=data:application/json;base64,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