"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DRAWIO_EXPLICIT_MAPPING = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const assets_1 = require("../../generated/assets");
/** Explicit mapping of drawio shapes to asset keys */
exports.DRAWIO_EXPLICIT_MAPPING = {
    access_analyzer: assets_1.AwsAsset.Resources.iam_iam_access_analyzer,
    agent: assets_1.AwsAsset.Resources.inspector_agent,
    agent2: assets_1.AwsAsset.Resources.datasync_agent,
    cluster: assets_1.AwsAsset.Resources.emr_cluster,
    connect: assets_1.AwsAsset.Resources.iot_greengrass_connector,
    archive: assets_1.AwsAsset.Resources.s3_glacier_archive,
    endpoints: assets_1.AwsAsset.Resources.vpc_endpoints,
    endpoint: assets_1.AwsAsset.Resources.network_firewall_endpoints,
    gateway: assets_1.AwsAsset.Resources.direct_connect_gateway,
    instance: assets_1.AwsAsset.Resources.ec2_instance,
    instances: assets_1.AwsAsset.Resources.ec2_instances,
    intelligent_tiering: assets_1.AwsAsset.Resources.s3_s3_intelligent_tiering,
    // iot_over_the_air_update: AwsAsset.Resources['iot_core_over_air_update'],
    registry: assets_1.AwsAsset.Resources.ecr_registry,
    router: assets_1.AwsAsset.Resources.vpc_router,
    simulator: assets_1.AwsAsset.Resources.iot_core_simulator,
    table: assets_1.AwsAsset.Resources.dynamodb_table,
    topic_2: assets_1.AwsAsset.Resources.iot_core_topic,
    topic: assets_1.AwsAsset.Resources.sns_topic,
    vault: assets_1.AwsAsset.Resources.s3_glacier_vault,
    volume: assets_1.AwsAsset.Resources.ebs_volume,
    peering: assets_1.AwsAsset.Resources.vpc_peering_connection,
    service: assets_1.AwsAsset.Services.ec2,
};
//# sourceMappingURL=data:application/json;base64,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