"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAssetPath = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const contants_1 = require("../../contants");
const definitions_1 = require("../categories/definitions");
/** Parse asset key into parts */
function parseAssetPath(assetPath) {
    if (assetPath.endsWith(contants_1.CATEGORY_ICON)) {
        const [category] = assetPath.split("/");
        return { assetKey: assetPath, category, basename: contants_1.CATEGORY_ICON };
    }
    if (assetPath.endsWith(contants_1.SERVICE_ICON)) {
        const [category, service] = assetPath.split("/");
        return { assetKey: assetPath, category, service, basename: contants_1.SERVICE_ICON };
    }
    if (assetPath.startsWith(definitions_1.AwsCategoryDefinitions.general.id)) {
        const [, basename] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category: definitions_1.AwsCategoryDefinitions.general.id,
            basename,
        };
    }
    if (assetPath.startsWith("compute/ec2/instance/")) {
        const [category, service, instanceDir, instanceType] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category,
            service,
            instanceType,
            basename: instanceDir + "/" + instanceType,
        };
    }
    if (assetPath.startsWith("internet_of_things/thing/")) {
        const [category, service, thingDir, iotThing] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category,
            service,
            iotThing,
            basename: thingDir + "/" + iotThing,
        };
    }
    const [category, service, basename] = assetPath.split("/");
    const resource = `${service}_${basename}`;
    return { assetKey: assetPath, category, service, resource, basename };
}
exports.parseAssetPath = parseAssetPath;
//# sourceMappingURL=data:application/json;base64,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