"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlSync = exports.readJsonSync = void 0;
const fs = require("fs");
const yaml_cfn = require("@aws-cdk/yaml-cfn");
function readJsonSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return JSON.parse(fileContents.toString());
}
exports.readJsonSync = readJsonSync;
function readYamlSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return yaml_cfn.deserialize(fileContents.toString());
}
exports.readYamlSync = readYamlSync;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS11dGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZpbGUtdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEseUJBQXlCO0FBQ3pCLDhDQUE4QztBQUU5QyxTQUFnQixZQUFZLENBQUMsUUFBZ0I7SUFDM0MsTUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMvQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7QUFDN0MsQ0FBQztBQUhELG9DQUdDO0FBRUQsU0FBZ0IsWUFBWSxDQUFDLFFBQWdCO0lBQzNDLE1BQU0sWUFBWSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDL0MsT0FBTyxRQUFRLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZELENBQUM7QUFIRCxvQ0FHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHlhbWxfY2ZuIGZyb20gJ0Bhd3MtY2RrL3lhbWwtY2ZuJztcblxuZXhwb3J0IGZ1bmN0aW9uIHJlYWRKc29uU3luYyhmaWxlUGF0aDogc3RyaW5nKTogYW55IHtcbiAgY29uc3QgZmlsZUNvbnRlbnRzID0gZnMucmVhZEZpbGVTeW5jKGZpbGVQYXRoKTtcbiAgcmV0dXJuIEpTT04ucGFyc2UoZmlsZUNvbnRlbnRzLnRvU3RyaW5nKCkpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVhZFlhbWxTeW5jKGZpbGVQYXRoOiBzdHJpbmcpOiBhbnkge1xuICBjb25zdCBmaWxlQ29udGVudHMgPSBmcy5yZWFkRmlsZVN5bmMoZmlsZVBhdGgpO1xuICByZXR1cm4geWFtbF9jZm4uZGVzZXJpYWxpemUoZmlsZUNvbnRlbnRzLnRvU3RyaW5nKCkpO1xufVxuIl19