<a id="mypy-boto3-sagemaker"></a>

# mypy-boto3-sagemaker

[![PyPI - mypy-boto3-sagemaker](https://img.shields.io/pypi/v/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-sagemaker?color=blue)](https://pypistats.org/packages/mypy-boto3-sagemaker)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.SageMaker 1.26.13](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/sagemaker.html#SageMaker)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.11.11](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sagemaker docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-sagemaker](#mypy-boto3-sagemaker)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `SageMaker`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `SageMaker` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[sagemaker]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[sagemaker]'


# standalone installation
python -m pip install mypy-boto3-sagemaker
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-sagemaker
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[sagemaker]` in your environment:

```bash
python -m pip install 'boto3-stubs[sagemaker]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[sagemaker]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[sagemaker]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[sagemaker]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[sagemaker]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[sagemaker]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[sagemaker]` in your environment:

```bash
python -m pip install 'boto3-stubs[sagemaker]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[sagemaker]` in your environment:

```bash
python -m pip install 'boto3-stubs[sagemaker]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SageMakerClient` provides annotations for `boto3.client("sagemaker")`.

```python
from boto3.session import Session

from mypy_boto3_sagemaker import SageMakerClient

client: SageMakerClient = Session().client("sagemaker")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_sagemaker.paginator` module contains type annotations for all
paginators.

```python
from boto3.session import Session

from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.paginator import (
    ListActionsPaginator,
    ListAlgorithmsPaginator,
    ListAppImageConfigsPaginator,
    ListAppsPaginator,
    ListArtifactsPaginator,
    ListAssociationsPaginator,
    ListAutoMLJobsPaginator,
    ListCandidatesForAutoMLJobPaginator,
    ListCodeRepositoriesPaginator,
    ListCompilationJobsPaginator,
    ListContextsPaginator,
    ListDataQualityJobDefinitionsPaginator,
    ListDeviceFleetsPaginator,
    ListDevicesPaginator,
    ListDomainsPaginator,
    ListEdgeDeploymentPlansPaginator,
    ListEdgePackagingJobsPaginator,
    ListEndpointConfigsPaginator,
    ListEndpointsPaginator,
    ListExperimentsPaginator,
    ListFeatureGroupsPaginator,
    ListFlowDefinitionsPaginator,
    ListHumanTaskUisPaginator,
    ListHyperParameterTuningJobsPaginator,
    ListImageVersionsPaginator,
    ListImagesPaginator,
    ListInferenceRecommendationsJobStepsPaginator,
    ListInferenceRecommendationsJobsPaginator,
    ListLabelingJobsPaginator,
    ListLabelingJobsForWorkteamPaginator,
    ListLineageGroupsPaginator,
    ListModelBiasJobDefinitionsPaginator,
    ListModelExplainabilityJobDefinitionsPaginator,
    ListModelMetadataPaginator,
    ListModelPackageGroupsPaginator,
    ListModelPackagesPaginator,
    ListModelQualityJobDefinitionsPaginator,
    ListModelsPaginator,
    ListMonitoringExecutionsPaginator,
    ListMonitoringSchedulesPaginator,
    ListNotebookInstanceLifecycleConfigsPaginator,
    ListNotebookInstancesPaginator,
    ListPipelineExecutionStepsPaginator,
    ListPipelineExecutionsPaginator,
    ListPipelineParametersForExecutionPaginator,
    ListPipelinesPaginator,
    ListProcessingJobsPaginator,
    ListStageDevicesPaginator,
    ListStudioLifecycleConfigsPaginator,
    ListSubscribedWorkteamsPaginator,
    ListTagsPaginator,
    ListTrainingJobsPaginator,
    ListTrainingJobsForHyperParameterTuningJobPaginator,
    ListTransformJobsPaginator,
    ListTrialComponentsPaginator,
    ListTrialsPaginator,
    ListUserProfilesPaginator,
    ListWorkforcesPaginator,
    ListWorkteamsPaginator,
    SearchPaginator,
)

client: SageMakerClient = Session().client("sagemaker")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
list_actions_paginator: ListActionsPaginator = client.get_paginator("list_actions")
list_algorithms_paginator: ListAlgorithmsPaginator = client.get_paginator("list_algorithms")
list_app_image_configs_paginator: ListAppImageConfigsPaginator = client.get_paginator(
    "list_app_image_configs"
)
list_apps_paginator: ListAppsPaginator = client.get_paginator("list_apps")
list_artifacts_paginator: ListArtifactsPaginator = client.get_paginator("list_artifacts")
list_associations_paginator: ListAssociationsPaginator = client.get_paginator("list_associations")
list_auto_ml_jobs_paginator: ListAutoMLJobsPaginator = client.get_paginator("list_auto_ml_jobs")
list_candidates_for_auto_ml_job_paginator: ListCandidatesForAutoMLJobPaginator = (
    client.get_paginator("list_candidates_for_auto_ml_job")
)
list_code_repositories_paginator: ListCodeRepositoriesPaginator = client.get_paginator(
    "list_code_repositories"
)
list_compilation_jobs_paginator: ListCompilationJobsPaginator = client.get_paginator(
    "list_compilation_jobs"
)
list_contexts_paginator: ListContextsPaginator = client.get_paginator("list_contexts")
list_data_quality_job_definitions_paginator: ListDataQualityJobDefinitionsPaginator = (
    client.get_paginator("list_data_quality_job_definitions")
)
list_device_fleets_paginator: ListDeviceFleetsPaginator = client.get_paginator("list_device_fleets")
list_devices_paginator: ListDevicesPaginator = client.get_paginator("list_devices")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_edge_deployment_plans_paginator: ListEdgeDeploymentPlansPaginator = client.get_paginator(
    "list_edge_deployment_plans"
)
list_edge_packaging_jobs_paginator: ListEdgePackagingJobsPaginator = client.get_paginator(
    "list_edge_packaging_jobs"
)
list_endpoint_configs_paginator: ListEndpointConfigsPaginator = client.get_paginator(
    "list_endpoint_configs"
)
list_endpoints_paginator: ListEndpointsPaginator = client.get_paginator("list_endpoints")
list_experiments_paginator: ListExperimentsPaginator = client.get_paginator("list_experiments")
list_feature_groups_paginator: ListFeatureGroupsPaginator = client.get_paginator(
    "list_feature_groups"
)
list_flow_definitions_paginator: ListFlowDefinitionsPaginator = client.get_paginator(
    "list_flow_definitions"
)
list_human_task_uis_paginator: ListHumanTaskUisPaginator = client.get_paginator(
    "list_human_task_uis"
)
list_hyper_parameter_tuning_jobs_paginator: ListHyperParameterTuningJobsPaginator = (
    client.get_paginator("list_hyper_parameter_tuning_jobs")
)
list_image_versions_paginator: ListImageVersionsPaginator = client.get_paginator(
    "list_image_versions"
)
list_images_paginator: ListImagesPaginator = client.get_paginator("list_images")
list_inference_recommendations_job_steps_paginator: ListInferenceRecommendationsJobStepsPaginator = client.get_paginator(
    "list_inference_recommendations_job_steps"
)
list_inference_recommendations_jobs_paginator: ListInferenceRecommendationsJobsPaginator = (
    client.get_paginator("list_inference_recommendations_jobs")
)
list_labeling_jobs_paginator: ListLabelingJobsPaginator = client.get_paginator("list_labeling_jobs")
list_labeling_jobs_for_workteam_paginator: ListLabelingJobsForWorkteamPaginator = (
    client.get_paginator("list_labeling_jobs_for_workteam")
)
list_lineage_groups_paginator: ListLineageGroupsPaginator = client.get_paginator(
    "list_lineage_groups"
)
list_model_bias_job_definitions_paginator: ListModelBiasJobDefinitionsPaginator = (
    client.get_paginator("list_model_bias_job_definitions")
)
list_model_explainability_job_definitions_paginator: ListModelExplainabilityJobDefinitionsPaginator = client.get_paginator(
    "list_model_explainability_job_definitions"
)
list_model_metadata_paginator: ListModelMetadataPaginator = client.get_paginator(
    "list_model_metadata"
)
list_model_package_groups_paginator: ListModelPackageGroupsPaginator = client.get_paginator(
    "list_model_package_groups"
)
list_model_packages_paginator: ListModelPackagesPaginator = client.get_paginator(
    "list_model_packages"
)
list_model_quality_job_definitions_paginator: ListModelQualityJobDefinitionsPaginator = (
    client.get_paginator("list_model_quality_job_definitions")
)
list_models_paginator: ListModelsPaginator = client.get_paginator("list_models")
list_monitoring_executions_paginator: ListMonitoringExecutionsPaginator = client.get_paginator(
    "list_monitoring_executions"
)
list_monitoring_schedules_paginator: ListMonitoringSchedulesPaginator = client.get_paginator(
    "list_monitoring_schedules"
)
list_notebook_instance_lifecycle_configs_paginator: ListNotebookInstanceLifecycleConfigsPaginator = client.get_paginator(
    "list_notebook_instance_lifecycle_configs"
)
list_notebook_instances_paginator: ListNotebookInstancesPaginator = client.get_paginator(
    "list_notebook_instances"
)
list_pipeline_execution_steps_paginator: ListPipelineExecutionStepsPaginator = client.get_paginator(
    "list_pipeline_execution_steps"
)
list_pipeline_executions_paginator: ListPipelineExecutionsPaginator = client.get_paginator(
    "list_pipeline_executions"
)
list_pipeline_parameters_for_execution_paginator: ListPipelineParametersForExecutionPaginator = (
    client.get_paginator("list_pipeline_parameters_for_execution")
)
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_processing_jobs_paginator: ListProcessingJobsPaginator = client.get_paginator(
    "list_processing_jobs"
)
list_stage_devices_paginator: ListStageDevicesPaginator = client.get_paginator("list_stage_devices")
list_studio_lifecycle_configs_paginator: ListStudioLifecycleConfigsPaginator = client.get_paginator(
    "list_studio_lifecycle_configs"
)
list_subscribed_workteams_paginator: ListSubscribedWorkteamsPaginator = client.get_paginator(
    "list_subscribed_workteams"
)
list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
list_training_jobs_paginator: ListTrainingJobsPaginator = client.get_paginator("list_training_jobs")
list_training_jobs_for_hyper_parameter_tuning_job_paginator: ListTrainingJobsForHyperParameterTuningJobPaginator = client.get_paginator(
    "list_training_jobs_for_hyper_parameter_tuning_job"
)
list_transform_jobs_paginator: ListTransformJobsPaginator = client.get_paginator(
    "list_transform_jobs"
)
list_trial_components_paginator: ListTrialComponentsPaginator = client.get_paginator(
    "list_trial_components"
)
list_trials_paginator: ListTrialsPaginator = client.get_paginator("list_trials")
list_user_profiles_paginator: ListUserProfilesPaginator = client.get_paginator("list_user_profiles")
list_workforces_paginator: ListWorkforcesPaginator = client.get_paginator("list_workforces")
list_workteams_paginator: ListWorkteamsPaginator = client.get_paginator("list_workteams")
search_paginator: SearchPaginator = client.get_paginator("search")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_sagemaker.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.waiter import (
    EndpointDeletedWaiter,
    EndpointInServiceWaiter,
    ImageCreatedWaiter,
    ImageDeletedWaiter,
    ImageUpdatedWaiter,
    ImageVersionCreatedWaiter,
    ImageVersionDeletedWaiter,
    NotebookInstanceDeletedWaiter,
    NotebookInstanceInServiceWaiter,
    NotebookInstanceStoppedWaiter,
    ProcessingJobCompletedOrStoppedWaiter,
    TrainingJobCompletedOrStoppedWaiter,
    TransformJobCompletedOrStoppedWaiter,
)

client: SageMakerClient = Session().client("sagemaker")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
endpoint_deleted_waiter: EndpointDeletedWaiter = client.get_waiter("endpoint_deleted")
endpoint_in_service_waiter: EndpointInServiceWaiter = client.get_waiter("endpoint_in_service")
image_created_waiter: ImageCreatedWaiter = client.get_waiter("image_created")
image_deleted_waiter: ImageDeletedWaiter = client.get_waiter("image_deleted")
image_updated_waiter: ImageUpdatedWaiter = client.get_waiter("image_updated")
image_version_created_waiter: ImageVersionCreatedWaiter = client.get_waiter("image_version_created")
image_version_deleted_waiter: ImageVersionDeletedWaiter = client.get_waiter("image_version_deleted")
notebook_instance_deleted_waiter: NotebookInstanceDeletedWaiter = client.get_waiter(
    "notebook_instance_deleted"
)
notebook_instance_in_service_waiter: NotebookInstanceInServiceWaiter = client.get_waiter(
    "notebook_instance_in_service"
)
notebook_instance_stopped_waiter: NotebookInstanceStoppedWaiter = client.get_waiter(
    "notebook_instance_stopped"
)
processing_job_completed_or_stopped_waiter: ProcessingJobCompletedOrStoppedWaiter = (
    client.get_waiter("processing_job_completed_or_stopped")
)
training_job_completed_or_stopped_waiter: TrainingJobCompletedOrStoppedWaiter = client.get_waiter(
    "training_job_completed_or_stopped"
)
transform_job_completed_or_stopped_waiter: TransformJobCompletedOrStoppedWaiter = client.get_waiter(
    "transform_job_completed_or_stopped"
)
```

<a id="literals"></a>

### Literals

`mypy_boto3_sagemaker.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_sagemaker.literals import (
    ActionStatusType,
    AlgorithmSortByType,
    AlgorithmStatusType,
    AppImageConfigSortKeyType,
    AppInstanceTypeType,
    AppNetworkAccessTypeType,
    AppSecurityGroupManagementType,
    AppSortKeyType,
    AppStatusType,
    AppTypeType,
    ArtifactSourceIdTypeType,
    AssemblyTypeType,
    AssociationEdgeTypeType,
    AthenaResultCompressionTypeType,
    AthenaResultFormatType,
    AuthModeType,
    AutoMLChannelTypeType,
    AutoMLJobObjectiveTypeType,
    AutoMLJobSecondaryStatusType,
    AutoMLJobStatusType,
    AutoMLMetricEnumType,
    AutoMLMetricExtendedEnumType,
    AutoMLModeType,
    AutoMLS3DataTypeType,
    AutoMLSortByType,
    AutoMLSortOrderType,
    AwsManagedHumanLoopRequestSourceType,
    BatchStrategyType,
    BooleanOperatorType,
    CandidateSortByType,
    CandidateStatusType,
    CandidateStepTypeType,
    CapacitySizeTypeType,
    CaptureModeType,
    CaptureStatusType,
    ClarifyFeatureTypeType,
    ClarifyTextGranularityType,
    ClarifyTextLanguageType,
    CodeRepositorySortByType,
    CodeRepositorySortOrderType,
    CompilationJobStatusType,
    CompressionTypeType,
    ConditionOutcomeType,
    ContainerModeType,
    ContentClassifierType,
    DataDistributionTypeType,
    DetailedAlgorithmStatusType,
    DetailedModelPackageStatusType,
    DeviceDeploymentStatusType,
    DeviceSubsetTypeType,
    DirectInternetAccessType,
    DirectionType,
    DomainStatusType,
    EdgePackagingJobStatusType,
    EdgePresetDeploymentStatusType,
    EdgePresetDeploymentTypeType,
    EndpointConfigSortKeyType,
    EndpointDeletedWaiterName,
    EndpointInServiceWaiterName,
    EndpointSortKeyType,
    EndpointStatusType,
    ExecutionRoleIdentityConfigType,
    ExecutionStatusType,
    FailureHandlingPolicyType,
    FeatureGroupSortByType,
    FeatureGroupSortOrderType,
    FeatureGroupStatusType,
    FeatureStatusType,
    FeatureTypeType,
    FileSystemAccessModeType,
    FileSystemTypeType,
    FlowDefinitionStatusType,
    FrameworkType,
    HumanTaskUiStatusType,
    HyperParameterScalingTypeType,
    HyperParameterTuningAllocationStrategyType,
    HyperParameterTuningJobObjectiveTypeType,
    HyperParameterTuningJobSortByOptionsType,
    HyperParameterTuningJobStatusType,
    HyperParameterTuningJobStrategyTypeType,
    HyperParameterTuningJobWarmStartTypeType,
    ImageCreatedWaiterName,
    ImageDeletedWaiterName,
    ImageSortByType,
    ImageSortOrderType,
    ImageStatusType,
    ImageUpdatedWaiterName,
    ImageVersionCreatedWaiterName,
    ImageVersionDeletedWaiterName,
    ImageVersionSortByType,
    ImageVersionSortOrderType,
    ImageVersionStatusType,
    InferenceExecutionModeType,
    InputModeType,
    InstanceTypeType,
    JoinSourceType,
    LabelingJobStatusType,
    LastUpdateStatusValueType,
    LineageTypeType,
    ListActionsPaginatorName,
    ListAlgorithmsPaginatorName,
    ListAppImageConfigsPaginatorName,
    ListAppsPaginatorName,
    ListArtifactsPaginatorName,
    ListAssociationsPaginatorName,
    ListAutoMLJobsPaginatorName,
    ListCandidatesForAutoMLJobPaginatorName,
    ListCodeRepositoriesPaginatorName,
    ListCompilationJobsPaginatorName,
    ListCompilationJobsSortByType,
    ListContextsPaginatorName,
    ListDataQualityJobDefinitionsPaginatorName,
    ListDeviceFleetsPaginatorName,
    ListDeviceFleetsSortByType,
    ListDevicesPaginatorName,
    ListDomainsPaginatorName,
    ListEdgeDeploymentPlansPaginatorName,
    ListEdgeDeploymentPlansSortByType,
    ListEdgePackagingJobsPaginatorName,
    ListEdgePackagingJobsSortByType,
    ListEndpointConfigsPaginatorName,
    ListEndpointsPaginatorName,
    ListExperimentsPaginatorName,
    ListFeatureGroupsPaginatorName,
    ListFlowDefinitionsPaginatorName,
    ListHumanTaskUisPaginatorName,
    ListHyperParameterTuningJobsPaginatorName,
    ListImageVersionsPaginatorName,
    ListImagesPaginatorName,
    ListInferenceRecommendationsJobStepsPaginatorName,
    ListInferenceRecommendationsJobsPaginatorName,
    ListInferenceRecommendationsJobsSortByType,
    ListLabelingJobsForWorkteamPaginatorName,
    ListLabelingJobsForWorkteamSortByOptionsType,
    ListLabelingJobsPaginatorName,
    ListLineageGroupsPaginatorName,
    ListModelBiasJobDefinitionsPaginatorName,
    ListModelExplainabilityJobDefinitionsPaginatorName,
    ListModelMetadataPaginatorName,
    ListModelPackageGroupsPaginatorName,
    ListModelPackagesPaginatorName,
    ListModelQualityJobDefinitionsPaginatorName,
    ListModelsPaginatorName,
    ListMonitoringExecutionsPaginatorName,
    ListMonitoringSchedulesPaginatorName,
    ListNotebookInstanceLifecycleConfigsPaginatorName,
    ListNotebookInstancesPaginatorName,
    ListPipelineExecutionStepsPaginatorName,
    ListPipelineExecutionsPaginatorName,
    ListPipelineParametersForExecutionPaginatorName,
    ListPipelinesPaginatorName,
    ListProcessingJobsPaginatorName,
    ListStageDevicesPaginatorName,
    ListStudioLifecycleConfigsPaginatorName,
    ListSubscribedWorkteamsPaginatorName,
    ListTagsPaginatorName,
    ListTrainingJobsForHyperParameterTuningJobPaginatorName,
    ListTrainingJobsPaginatorName,
    ListTransformJobsPaginatorName,
    ListTrialComponentsPaginatorName,
    ListTrialsPaginatorName,
    ListUserProfilesPaginatorName,
    ListWorkforcesPaginatorName,
    ListWorkforcesSortByOptionsType,
    ListWorkteamsPaginatorName,
    ListWorkteamsSortByOptionsType,
    MetricSetSourceType,
    ModelApprovalStatusType,
    ModelCacheSettingType,
    ModelMetadataFilterTypeType,
    ModelPackageGroupSortByType,
    ModelPackageGroupStatusType,
    ModelPackageSortByType,
    ModelPackageStatusType,
    ModelPackageTypeType,
    ModelSortKeyType,
    MonitoringExecutionSortKeyType,
    MonitoringJobDefinitionSortKeyType,
    MonitoringProblemTypeType,
    MonitoringScheduleSortKeyType,
    MonitoringTypeType,
    NotebookInstanceAcceleratorTypeType,
    NotebookInstanceDeletedWaiterName,
    NotebookInstanceInServiceWaiterName,
    NotebookInstanceLifecycleConfigSortKeyType,
    NotebookInstanceLifecycleConfigSortOrderType,
    NotebookInstanceSortKeyType,
    NotebookInstanceSortOrderType,
    NotebookInstanceStatusType,
    NotebookInstanceStoppedWaiterName,
    NotebookOutputOptionType,
    ObjectiveStatusType,
    OfflineStoreStatusValueType,
    OperatorType,
    OrderKeyType,
    ParameterTypeType,
    PipelineExecutionStatusType,
    PipelineStatusType,
    ProblemTypeType,
    ProcessingInstanceTypeType,
    ProcessingJobCompletedOrStoppedWaiterName,
    ProcessingJobStatusType,
    ProcessingS3CompressionTypeType,
    ProcessingS3DataDistributionTypeType,
    ProcessingS3DataTypeType,
    ProcessingS3InputModeType,
    ProcessingS3UploadModeType,
    ProductionVariantAcceleratorTypeType,
    ProductionVariantInstanceTypeType,
    ProfilingStatusType,
    ProjectSortByType,
    ProjectSortOrderType,
    ProjectStatusType,
    RStudioServerProAccessStatusType,
    RStudioServerProUserGroupType,
    RecommendationJobStatusType,
    RecommendationJobTypeType,
    RecommendationStepTypeType,
    RecordWrapperType,
    RedshiftResultCompressionTypeType,
    RedshiftResultFormatType,
    RepositoryAccessModeType,
    ResourceTypeType,
    RetentionTypeType,
    RootAccessType,
    RuleEvaluationStatusType,
    S3DataDistributionType,
    S3DataTypeType,
    SagemakerServicecatalogStatusType,
    ScheduleStatusType,
    SearchPaginatorName,
    SearchSortOrderType,
    SecondaryStatusType,
    SortActionsByType,
    SortArtifactsByType,
    SortAssociationsByType,
    SortByType,
    SortContextsByType,
    SortExperimentsByType,
    SortLineageGroupsByType,
    SortOrderType,
    SortPipelineExecutionsByType,
    SortPipelinesByType,
    SortTrialComponentsByType,
    SortTrialsByType,
    SplitTypeType,
    StageStatusType,
    StepStatusType,
    StudioLifecycleConfigAppTypeType,
    StudioLifecycleConfigSortKeyType,
    TargetDeviceType,
    TargetPlatformAcceleratorType,
    TargetPlatformArchType,
    TargetPlatformOsType,
    TrafficRoutingConfigTypeType,
    TrafficTypeType,
    TrainingInputModeType,
    TrainingInstanceTypeType,
    TrainingJobCompletedOrStoppedWaiterName,
    TrainingJobEarlyStoppingTypeType,
    TrainingJobSortByOptionsType,
    TrainingJobStatusType,
    TransformInstanceTypeType,
    TransformJobCompletedOrStoppedWaiterName,
    TransformJobStatusType,
    TrialComponentPrimaryStatusType,
    UserProfileSortKeyType,
    UserProfileStatusType,
    VariantPropertyTypeType,
    VariantStatusType,
    WarmPoolResourceStatusType,
    WorkforceStatusType,
    SageMakerServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)


def check_value(value: ActionStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sagemaker.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_sagemaker.type_defs import (
    ActionSourceTypeDef,
    AddAssociationRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    TagTypeDef,
    AgentVersionTypeDef,
    AlarmTypeDef,
    MetricDefinitionTypeDef,
    AlgorithmStatusItemTypeDef,
    AlgorithmSummaryTypeDef,
    AnnotationConsolidationConfigTypeDef,
    AppDetailsTypeDef,
    AppSpecificationTypeDef,
    ArtifactSourceTypeTypeDef,
    AssociateTrialComponentRequestRequestTypeDef,
    UserContextTypeDef,
    AsyncInferenceClientConfigTypeDef,
    AsyncInferenceNotificationConfigTypeDef,
    AthenaDatasetDefinitionTypeDef,
    AutoMLCandidateGenerationConfigTypeDef,
    AutoMLCandidateStepTypeDef,
    AutoMLContainerDefinitionTypeDef,
    FinalAutoMLJobObjectiveMetricTypeDef,
    AutoMLS3DataSourceTypeDef,
    AutoMLDataSplitConfigTypeDef,
    AutoMLJobArtifactsTypeDef,
    AutoMLJobCompletionCriteriaTypeDef,
    AutoMLJobObjectiveTypeDef,
    AutoMLPartialFailureReasonTypeDef,
    AutoMLOutputDataConfigTypeDef,
    VpcConfigTypeDef,
    BatchDataCaptureConfigTypeDef,
    BatchDescribeModelPackageErrorTypeDef,
    BatchDescribeModelPackageInputRequestTypeDef,
    MetricsSourceTypeDef,
    CacheHitResultTypeDef,
    OutputParameterTypeDef,
    CandidateArtifactLocationsTypeDef,
    MetricDatumTypeDef,
    TimeSeriesForecastingSettingsTypeDef,
    CapacitySizeTypeDef,
    CaptureContentTypeHeaderTypeDef,
    CaptureOptionTypeDef,
    CategoricalParameterRangeSpecificationTypeDef,
    CategoricalParameterRangeTypeDef,
    CategoricalParameterTypeDef,
    ChannelSpecificationTypeDef,
    ShuffleConfigTypeDef,
    CheckpointConfigTypeDef,
    ClarifyCheckStepMetadataTypeDef,
    ClarifyInferenceConfigTypeDef,
    ClarifyShapBaselineConfigTypeDef,
    ClarifyTextConfigTypeDef,
    GitConfigTypeDef,
    CognitoConfigTypeDef,
    CognitoMemberDefinitionTypeDef,
    CollectionConfigurationTypeDef,
    CompilationJobSummaryTypeDef,
    ConditionStepMetadataTypeDef,
    MultiModelConfigTypeDef,
    ContextSourceTypeDef,
    ContinuousParameterRangeSpecificationTypeDef,
    ContinuousParameterRangeTypeDef,
    MetadataPropertiesTypeDef,
    ResourceSpecTypeDef,
    ModelDeployConfigTypeDef,
    InputConfigTypeDef,
    NeoVpcConfigTypeDef,
    StoppingConditionTypeDef,
    DataQualityAppSpecificationTypeDef,
    MonitoringStoppingConditionTypeDef,
    EdgeOutputConfigTypeDef,
    EdgeDeploymentModelConfigTypeDef,
    FeatureDefinitionTypeDef,
    FlowDefinitionOutputConfigTypeDef,
    HumanLoopRequestSourceTypeDef,
    UiTemplateTypeDef,
    CreateImageVersionRequestRequestTypeDef,
    LabelingJobOutputConfigTypeDef,
    LabelingJobStoppingConditionsTypeDef,
    ModelBiasAppSpecificationTypeDef,
    ModelExplainabilityAppSpecificationTypeDef,
    InferenceExecutionConfigTypeDef,
    ModelQualityAppSpecificationTypeDef,
    InstanceMetadataServiceConfigurationTypeDef,
    NotebookInstanceLifecycleHookTypeDef,
    ParallelismConfigurationTypeDef,
    PipelineDefinitionS3LocationTypeDef,
    CreatePresignedDomainUrlRequestRequestTypeDef,
    CreatePresignedNotebookInstanceUrlInputRequestTypeDef,
    ExperimentConfigTypeDef,
    ProcessingStoppingConditionTypeDef,
    DebugRuleConfigurationTypeDef,
    OutputDataConfigTypeDef,
    ProfilerConfigTypeDef,
    ProfilerRuleConfigurationTypeDef,
    RetryStrategyTypeDef,
    TensorBoardOutputConfigTypeDef,
    DataProcessingTypeDef,
    ModelClientConfigTypeDef,
    TransformOutputTypeDef,
    TransformResourcesTypeDef,
    TrialComponentArtifactTypeDef,
    TrialComponentParameterValueTypeDef,
    TrialComponentStatusTypeDef,
    OidcConfigTypeDef,
    SourceIpConfigTypeDef,
    WorkforceVpcConfigRequestTypeDef,
    NotificationConfigurationTypeDef,
    CustomImageTypeDef,
    DataCaptureConfigSummaryTypeDef,
    DataCatalogConfigTypeDef,
    MonitoringConstraintsResourceTypeDef,
    MonitoringStatisticsResourceTypeDef,
    EndpointInputTypeDef,
    FileSystemDataSourceTypeDef,
    S3DataSourceTypeDef,
    RedshiftDatasetDefinitionTypeDef,
    DebugRuleEvaluationStatusTypeDef,
    DeleteActionRequestRequestTypeDef,
    DeleteAlgorithmInputRequestTypeDef,
    DeleteAppImageConfigRequestRequestTypeDef,
    DeleteAppRequestRequestTypeDef,
    DeleteAssociationRequestRequestTypeDef,
    DeleteCodeRepositoryInputRequestTypeDef,
    DeleteContextRequestRequestTypeDef,
    DeleteDataQualityJobDefinitionRequestRequestTypeDef,
    DeleteDeviceFleetRequestRequestTypeDef,
    RetentionPolicyTypeDef,
    DeleteEdgeDeploymentPlanRequestRequestTypeDef,
    DeleteEdgeDeploymentStageRequestRequestTypeDef,
    DeleteEndpointConfigInputRequestTypeDef,
    DeleteEndpointInputRequestTypeDef,
    DeleteExperimentRequestRequestTypeDef,
    DeleteFeatureGroupRequestRequestTypeDef,
    DeleteFlowDefinitionRequestRequestTypeDef,
    DeleteHumanTaskUiRequestRequestTypeDef,
    DeleteImageRequestRequestTypeDef,
    DeleteImageVersionRequestRequestTypeDef,
    DeleteModelBiasJobDefinitionRequestRequestTypeDef,
    DeleteModelExplainabilityJobDefinitionRequestRequestTypeDef,
    DeleteModelInputRequestTypeDef,
    DeleteModelPackageGroupInputRequestTypeDef,
    DeleteModelPackageGroupPolicyInputRequestTypeDef,
    DeleteModelPackageInputRequestTypeDef,
    DeleteModelQualityJobDefinitionRequestRequestTypeDef,
    DeleteMonitoringScheduleRequestRequestTypeDef,
    DeleteNotebookInstanceInputRequestTypeDef,
    DeleteNotebookInstanceLifecycleConfigInputRequestTypeDef,
    DeletePipelineRequestRequestTypeDef,
    DeleteProjectInputRequestTypeDef,
    DeleteStudioLifecycleConfigRequestRequestTypeDef,
    DeleteTagsInputRequestTypeDef,
    DeleteTrialComponentRequestRequestTypeDef,
    DeleteTrialRequestRequestTypeDef,
    DeleteUserProfileRequestRequestTypeDef,
    DeleteWorkforceRequestRequestTypeDef,
    DeleteWorkteamRequestRequestTypeDef,
    DeployedImageTypeDef,
    DeviceSelectionConfigTypeDef,
    EdgeDeploymentConfigTypeDef,
    EdgeDeploymentStatusTypeDef,
    DeregisterDevicesRequestRequestTypeDef,
    DescribeActionRequestRequestTypeDef,
    DescribeAlgorithmInputRequestTypeDef,
    DescribeAppImageConfigRequestRequestTypeDef,
    DescribeAppRequestRequestTypeDef,
    DescribeArtifactRequestRequestTypeDef,
    DescribeAutoMLJobRequestRequestTypeDef,
    ModelDeployResultTypeDef,
    DescribeCodeRepositoryInputRequestTypeDef,
    DescribeCompilationJobRequestRequestTypeDef,
    ModelArtifactsTypeDef,
    ModelDigestsTypeDef,
    DescribeContextRequestRequestTypeDef,
    DescribeDataQualityJobDefinitionRequestRequestTypeDef,
    DescribeDeviceFleetRequestRequestTypeDef,
    DescribeDeviceRequestRequestTypeDef,
    EdgeModelTypeDef,
    DescribeDomainRequestRequestTypeDef,
    DescribeEdgeDeploymentPlanRequestRequestTypeDef,
    DescribeEdgePackagingJobRequestRequestTypeDef,
    EdgePresetDeploymentOutputTypeDef,
    DescribeEndpointConfigInputRequestTypeDef,
    WaiterConfigTypeDef,
    DescribeEndpointInputRequestTypeDef,
    DescribeExperimentRequestRequestTypeDef,
    ExperimentSourceTypeDef,
    DescribeFeatureGroupRequestRequestTypeDef,
    LastUpdateStatusTypeDef,
    OfflineStoreStatusTypeDef,
    DescribeFeatureMetadataRequestRequestTypeDef,
    FeatureParameterTypeDef,
    DescribeFlowDefinitionRequestRequestTypeDef,
    DescribeHumanTaskUiRequestRequestTypeDef,
    UiTemplateInfoTypeDef,
    DescribeHyperParameterTuningJobRequestRequestTypeDef,
    ObjectiveStatusCountersTypeDef,
    TrainingJobStatusCountersTypeDef,
    DescribeImageRequestRequestTypeDef,
    DescribeImageVersionRequestRequestTypeDef,
    DescribeInferenceRecommendationsJobRequestRequestTypeDef,
    DescribeLabelingJobRequestRequestTypeDef,
    LabelCountersTypeDef,
    LabelingJobOutputTypeDef,
    DescribeLineageGroupRequestRequestTypeDef,
    DescribeModelBiasJobDefinitionRequestRequestTypeDef,
    DescribeModelExplainabilityJobDefinitionRequestRequestTypeDef,
    DescribeModelInputRequestTypeDef,
    DescribeModelPackageGroupInputRequestTypeDef,
    DescribeModelPackageInputRequestTypeDef,
    DescribeModelQualityJobDefinitionRequestRequestTypeDef,
    DescribeMonitoringScheduleRequestRequestTypeDef,
    MonitoringExecutionSummaryTypeDef,
    DescribeNotebookInstanceInputRequestTypeDef,
    DescribeNotebookInstanceLifecycleConfigInputRequestTypeDef,
    DescribePipelineDefinitionForExecutionRequestRequestTypeDef,
    DescribePipelineExecutionRequestRequestTypeDef,
    PipelineExperimentConfigTypeDef,
    DescribePipelineRequestRequestTypeDef,
    DescribeProcessingJobRequestRequestTypeDef,
    DescribeProjectInputRequestTypeDef,
    ServiceCatalogProvisionedProductDetailsTypeDef,
    DescribeStudioLifecycleConfigRequestRequestTypeDef,
    DescribeSubscribedWorkteamRequestRequestTypeDef,
    SubscribedWorkteamTypeDef,
    DescribeTrainingJobRequestRequestTypeDef,
    MetricDataTypeDef,
    ProfilerRuleEvaluationStatusTypeDef,
    SecondaryStatusTransitionTypeDef,
    WarmPoolStatusTypeDef,
    DescribeTransformJobRequestRequestTypeDef,
    DescribeTrialComponentRequestRequestTypeDef,
    TrialComponentMetricSummaryTypeDef,
    TrialComponentSourceTypeDef,
    DescribeTrialRequestRequestTypeDef,
    TrialSourceTypeDef,
    DescribeUserProfileRequestRequestTypeDef,
    DescribeWorkforceRequestRequestTypeDef,
    DescribeWorkteamRequestRequestTypeDef,
    DesiredWeightAndCapacityTypeDef,
    DeviceDeploymentSummaryTypeDef,
    DeviceFleetSummaryTypeDef,
    DeviceStatsTypeDef,
    EdgeModelSummaryTypeDef,
    DeviceTypeDef,
    DisassociateTrialComponentRequestRequestTypeDef,
    DomainDetailsTypeDef,
    FileSourceTypeDef,
    EMRStepMetadataTypeDef,
    EdgeDeploymentPlanSummaryTypeDef,
    EdgeModelStatTypeDef,
    EdgePackagingJobSummaryTypeDef,
    EdgeTypeDef,
    EndpointConfigSummaryTypeDef,
    EndpointInfoTypeDef,
    EndpointOutputConfigurationTypeDef,
    InferenceMetricsTypeDef,
    EndpointSummaryTypeDef,
    EnvironmentParameterTypeDef,
    FailStepMetadataTypeDef,
    FileSystemConfigTypeDef,
    FilterTypeDef,
    FinalHyperParameterTuningJobObjectiveMetricTypeDef,
    FlowDefinitionSummaryTypeDef,
    GetDeviceFleetReportRequestRequestTypeDef,
    GetLineageGroupPolicyRequestRequestTypeDef,
    GetModelPackageGroupPolicyInputRequestTypeDef,
    PropertyNameSuggestionTypeDef,
    GitConfigForUpdateTypeDef,
    HumanLoopActivationConditionsConfigTypeDef,
    UiConfigTypeDef,
    HumanTaskUiSummaryTypeDef,
    HyperParameterTuningJobObjectiveTypeDef,
    HyperParameterTuningInstanceConfigTypeDef,
    ResourceLimitsTypeDef,
    TuningJobCompletionCriteriaTypeDef,
    HyperbandStrategyConfigTypeDef,
    ParentHyperParameterTuningJobTypeDef,
    RepositoryAuthConfigTypeDef,
    ImageTypeDef,
    ImageVersionTypeDef,
    RecommendationMetricsTypeDef,
    InferenceRecommendationsJobTypeDef,
    InstanceGroupTypeDef,
    IntegerParameterRangeSpecificationTypeDef,
    IntegerParameterRangeTypeDef,
    KernelSpecTypeDef,
    LabelCountersForWorkteamTypeDef,
    LabelingJobDataAttributesTypeDef,
    LabelingJobS3DataSourceTypeDef,
    LabelingJobSnsDataSourceTypeDef,
    LineageGroupSummaryTypeDef,
    PaginatorConfigTypeDef,
    ListActionsRequestRequestTypeDef,
    ListAlgorithmsInputRequestTypeDef,
    ListAppImageConfigsRequestRequestTypeDef,
    ListAppsRequestRequestTypeDef,
    ListArtifactsRequestRequestTypeDef,
    ListAssociationsRequestRequestTypeDef,
    ListAutoMLJobsRequestRequestTypeDef,
    ListCandidatesForAutoMLJobRequestRequestTypeDef,
    ListCodeRepositoriesInputRequestTypeDef,
    ListCompilationJobsRequestRequestTypeDef,
    ListContextsRequestRequestTypeDef,
    ListDataQualityJobDefinitionsRequestRequestTypeDef,
    MonitoringJobDefinitionSummaryTypeDef,
    ListDeviceFleetsRequestRequestTypeDef,
    ListDevicesRequestRequestTypeDef,
    ListDomainsRequestRequestTypeDef,
    ListEdgeDeploymentPlansRequestRequestTypeDef,
    ListEdgePackagingJobsRequestRequestTypeDef,
    ListEndpointConfigsInputRequestTypeDef,
    ListEndpointsInputRequestTypeDef,
    ListExperimentsRequestRequestTypeDef,
    ListFeatureGroupsRequestRequestTypeDef,
    ListFlowDefinitionsRequestRequestTypeDef,
    ListHumanTaskUisRequestRequestTypeDef,
    ListHyperParameterTuningJobsRequestRequestTypeDef,
    ListImageVersionsRequestRequestTypeDef,
    ListImagesRequestRequestTypeDef,
    ListInferenceRecommendationsJobStepsRequestRequestTypeDef,
    ListInferenceRecommendationsJobsRequestRequestTypeDef,
    ListLabelingJobsForWorkteamRequestRequestTypeDef,
    ListLabelingJobsRequestRequestTypeDef,
    ListLineageGroupsRequestRequestTypeDef,
    ListModelBiasJobDefinitionsRequestRequestTypeDef,
    ListModelExplainabilityJobDefinitionsRequestRequestTypeDef,
    ModelMetadataSummaryTypeDef,
    ListModelPackageGroupsInputRequestTypeDef,
    ModelPackageGroupSummaryTypeDef,
    ListModelPackagesInputRequestTypeDef,
    ModelPackageSummaryTypeDef,
    ListModelQualityJobDefinitionsRequestRequestTypeDef,
    ListModelsInputRequestTypeDef,
    ModelSummaryTypeDef,
    ListMonitoringExecutionsRequestRequestTypeDef,
    ListMonitoringSchedulesRequestRequestTypeDef,
    MonitoringScheduleSummaryTypeDef,
    ListNotebookInstanceLifecycleConfigsInputRequestTypeDef,
    NotebookInstanceLifecycleConfigSummaryTypeDef,
    ListNotebookInstancesInputRequestTypeDef,
    NotebookInstanceSummaryTypeDef,
    ListPipelineExecutionStepsRequestRequestTypeDef,
    ListPipelineExecutionsRequestRequestTypeDef,
    PipelineExecutionSummaryTypeDef,
    ListPipelineParametersForExecutionRequestRequestTypeDef,
    ParameterTypeDef,
    ListPipelinesRequestRequestTypeDef,
    PipelineSummaryTypeDef,
    ListProcessingJobsRequestRequestTypeDef,
    ProcessingJobSummaryTypeDef,
    ListProjectsInputRequestTypeDef,
    ProjectSummaryTypeDef,
    ListStageDevicesRequestRequestTypeDef,
    ListStudioLifecycleConfigsRequestRequestTypeDef,
    StudioLifecycleConfigDetailsTypeDef,
    ListSubscribedWorkteamsRequestRequestTypeDef,
    ListTagsInputRequestTypeDef,
    ListTrainingJobsForHyperParameterTuningJobRequestRequestTypeDef,
    ListTrainingJobsRequestRequestTypeDef,
    ListTransformJobsRequestRequestTypeDef,
    TransformJobSummaryTypeDef,
    ListTrialComponentsRequestRequestTypeDef,
    ListTrialsRequestRequestTypeDef,
    ListUserProfilesRequestRequestTypeDef,
    UserProfileDetailsTypeDef,
    ListWorkforcesRequestRequestTypeDef,
    ListWorkteamsRequestRequestTypeDef,
    OidcMemberDefinitionTypeDef,
    MonitoringGroundTruthS3InputTypeDef,
    ModelInputTypeDef,
    ModelLatencyThresholdTypeDef,
    ModelMetadataFilterTypeDef,
    ModelPackageStatusItemTypeDef,
    ModelStepMetadataTypeDef,
    MonitoringAppSpecificationTypeDef,
    MonitoringClusterConfigTypeDef,
    MonitoringCsvDatasetFormatTypeDef,
    MonitoringJsonDatasetFormatTypeDef,
    MonitoringS3OutputTypeDef,
    ScheduleConfigTypeDef,
    S3StorageConfigTypeDef,
    OidcConfigForResponseTypeDef,
    OnlineStoreSecurityConfigTypeDef,
    TargetPlatformTypeDef,
    ParentTypeDef,
    ProductionVariantServerlessConfigTypeDef,
    ProductionVariantStatusTypeDef,
    PhaseTypeDef,
    ProcessingJobStepMetadataTypeDef,
    QualityCheckStepMetadataTypeDef,
    RegisterModelStepMetadataTypeDef,
    TrainingJobStepMetadataTypeDef,
    TransformJobStepMetadataTypeDef,
    TuningJobStepMetaDataTypeDef,
    ProcessingClusterConfigTypeDef,
    ProcessingFeatureStoreOutputTypeDef,
    ProcessingS3InputTypeDef,
    ProcessingS3OutputTypeDef,
    ProductionVariantCoreDumpConfigTypeDef,
    ProfilerConfigForUpdateTypeDef,
    PropertyNameQueryTypeDef,
    ProvisioningParameterTypeDef,
    USDTypeDef,
    PutModelPackageGroupPolicyInputRequestTypeDef,
    QueryFiltersTypeDef,
    VertexTypeDef,
    RStudioServerProAppSettingsTypeDef,
    RecommendationJobCompiledOutputConfigTypeDef,
    RecommendationJobPayloadConfigTypeDef,
    RecommendationJobResourceLimitTypeDef,
    RenderableTaskTypeDef,
    RenderingErrorTypeDef,
    ResourceConfigForUpdateTypeDef,
    SearchRequestRequestTypeDef,
    SendPipelineExecutionStepFailureRequestRequestTypeDef,
    SharingSettingsTypeDef,
    SourceAlgorithmTypeDef,
    StartEdgeDeploymentStageRequestRequestTypeDef,
    StartMonitoringScheduleRequestRequestTypeDef,
    StartNotebookInstanceInputRequestTypeDef,
    StopAutoMLJobRequestRequestTypeDef,
    StopCompilationJobRequestRequestTypeDef,
    StopEdgeDeploymentStageRequestRequestTypeDef,
    StopEdgePackagingJobRequestRequestTypeDef,
    StopHyperParameterTuningJobRequestRequestTypeDef,
    StopInferenceRecommendationsJobRequestRequestTypeDef,
    StopLabelingJobRequestRequestTypeDef,
    StopMonitoringScheduleRequestRequestTypeDef,
    StopNotebookInstanceInputRequestTypeDef,
    StopPipelineExecutionRequestRequestTypeDef,
    StopProcessingJobRequestRequestTypeDef,
    StopTrainingJobRequestRequestTypeDef,
    StopTransformJobRequestRequestTypeDef,
    TransformS3DataSourceTypeDef,
    UpdateActionRequestRequestTypeDef,
    UpdateArtifactRequestRequestTypeDef,
    UpdateContextRequestRequestTypeDef,
    VariantPropertyTypeDef,
    UpdateExperimentRequestRequestTypeDef,
    UpdateImageRequestRequestTypeDef,
    UpdateTrialRequestRequestTypeDef,
    WorkforceVpcConfigResponseTypeDef,
    ActionSummaryTypeDef,
    AddAssociationResponseTypeDef,
    AssociateTrialComponentResponseTypeDef,
    CreateActionResponseTypeDef,
    CreateAlgorithmOutputTypeDef,
    CreateAppImageConfigResponseTypeDef,
    CreateAppResponseTypeDef,
    CreateArtifactResponseTypeDef,
    CreateAutoMLJobResponseTypeDef,
    CreateCodeRepositoryOutputTypeDef,
    CreateCompilationJobResponseTypeDef,
    CreateContextResponseTypeDef,
    CreateDataQualityJobDefinitionResponseTypeDef,
    CreateDomainResponseTypeDef,
    CreateEdgeDeploymentPlanResponseTypeDef,
    CreateEndpointConfigOutputTypeDef,
    CreateEndpointOutputTypeDef,
    CreateExperimentResponseTypeDef,
    CreateFeatureGroupResponseTypeDef,
    CreateFlowDefinitionResponseTypeDef,
    CreateHumanTaskUiResponseTypeDef,
    CreateHyperParameterTuningJobResponseTypeDef,
    CreateImageResponseTypeDef,
    CreateImageVersionResponseTypeDef,
    CreateInferenceRecommendationsJobResponseTypeDef,
    CreateLabelingJobResponseTypeDef,
    CreateModelBiasJobDefinitionResponseTypeDef,
    CreateModelExplainabilityJobDefinitionResponseTypeDef,
    CreateModelOutputTypeDef,
    CreateModelPackageGroupOutputTypeDef,
    CreateModelPackageOutputTypeDef,
    CreateModelQualityJobDefinitionResponseTypeDef,
    CreateMonitoringScheduleResponseTypeDef,
    CreateNotebookInstanceLifecycleConfigOutputTypeDef,
    CreateNotebookInstanceOutputTypeDef,
    CreatePipelineResponseTypeDef,
    CreatePresignedDomainUrlResponseTypeDef,
    CreatePresignedNotebookInstanceUrlOutputTypeDef,
    CreateProcessingJobResponseTypeDef,
    CreateProjectOutputTypeDef,
    CreateStudioLifecycleConfigResponseTypeDef,
    CreateTrainingJobResponseTypeDef,
    CreateTransformJobResponseTypeDef,
    CreateTrialComponentResponseTypeDef,
    CreateTrialResponseTypeDef,
    CreateUserProfileResponseTypeDef,
    CreateWorkforceResponseTypeDef,
    CreateWorkteamResponseTypeDef,
    DeleteActionResponseTypeDef,
    DeleteArtifactResponseTypeDef,
    DeleteAssociationResponseTypeDef,
    DeleteContextResponseTypeDef,
    DeleteExperimentResponseTypeDef,
    DeletePipelineResponseTypeDef,
    DeleteTrialComponentResponseTypeDef,
    DeleteTrialResponseTypeDef,
    DeleteWorkteamResponseTypeDef,
    DescribeImageResponseTypeDef,
    DescribeImageVersionResponseTypeDef,
    DescribePipelineDefinitionForExecutionResponseTypeDef,
    DescribeStudioLifecycleConfigResponseTypeDef,
    DisassociateTrialComponentResponseTypeDef,
    EmptyResponseMetadataTypeDef,
    GetLineageGroupPolicyResponseTypeDef,
    GetModelPackageGroupPolicyOutputTypeDef,
    GetSagemakerServicecatalogPortfolioStatusOutputTypeDef,
    PutModelPackageGroupPolicyOutputTypeDef,
    RetryPipelineExecutionResponseTypeDef,
    SendPipelineExecutionStepFailureResponseTypeDef,
    SendPipelineExecutionStepSuccessResponseTypeDef,
    StartPipelineExecutionResponseTypeDef,
    StopPipelineExecutionResponseTypeDef,
    UpdateActionResponseTypeDef,
    UpdateAppImageConfigResponseTypeDef,
    UpdateArtifactResponseTypeDef,
    UpdateCodeRepositoryOutputTypeDef,
    UpdateContextResponseTypeDef,
    UpdateDomainResponseTypeDef,
    UpdateEndpointOutputTypeDef,
    UpdateEndpointWeightsAndCapacitiesOutputTypeDef,
    UpdateExperimentResponseTypeDef,
    UpdateFeatureGroupResponseTypeDef,
    UpdateImageResponseTypeDef,
    UpdateModelPackageOutputTypeDef,
    UpdateMonitoringScheduleResponseTypeDef,
    UpdatePipelineExecutionResponseTypeDef,
    UpdatePipelineResponseTypeDef,
    UpdateProjectOutputTypeDef,
    UpdateTrainingJobResponseTypeDef,
    UpdateTrialComponentResponseTypeDef,
    UpdateTrialResponseTypeDef,
    UpdateUserProfileResponseTypeDef,
    AddTagsInputRequestTypeDef,
    AddTagsOutputTypeDef,
    CreateExperimentRequestRequestTypeDef,
    CreateImageRequestRequestTypeDef,
    CreateModelPackageGroupInputRequestTypeDef,
    CreateStudioLifecycleConfigRequestRequestTypeDef,
    ListTagsOutputTypeDef,
    AutoRollbackConfigTypeDef,
    AlgorithmSpecificationTypeDef,
    HyperParameterAlgorithmSpecificationTypeDef,
    AlgorithmStatusDetailsTypeDef,
    ListAlgorithmsOutputTypeDef,
    ListAppsResponseTypeDef,
    ArtifactSourceTypeDef,
    AssociationSummaryTypeDef,
    DescribeLineageGroupResponseTypeDef,
    DescribeModelPackageGroupOutputTypeDef,
    ModelPackageGroupTypeDef,
    AsyncInferenceOutputConfigTypeDef,
    AutoMLDataSourceTypeDef,
    ResolvedAttributesTypeDef,
    AutoMLJobSummaryTypeDef,
    AutoMLSecurityConfigTypeDef,
    LabelingJobResourceConfigTypeDef,
    MonitoringNetworkConfigTypeDef,
    NetworkConfigTypeDef,
    BiasTypeDef,
    DriftCheckModelDataQualityTypeDef,
    DriftCheckModelQualityTypeDef,
    ExplainabilityTypeDef,
    ModelDataQualityTypeDef,
    ModelQualityTypeDef,
    CallbackStepMetadataTypeDef,
    LambdaStepMetadataTypeDef,
    SendPipelineExecutionStepSuccessRequestRequestTypeDef,
    CandidatePropertiesTypeDef,
    CanvasAppSettingsTypeDef,
    TrafficRoutingConfigTypeDef,
    DataCaptureConfigTypeDef,
    EnvironmentParameterRangesTypeDef,
    ClarifyShapConfigTypeDef,
    CodeRepositorySummaryTypeDef,
    CreateCodeRepositoryInputRequestTypeDef,
    DescribeCodeRepositoryOutputTypeDef,
    DebugHookConfigTypeDef,
    ListCompilationJobsResponseTypeDef,
    ContextSummaryTypeDef,
    CreateContextRequestRequestTypeDef,
    DescribeContextResponseTypeDef,
    CreateActionRequestRequestTypeDef,
    CreateTrialRequestRequestTypeDef,
    DescribeActionResponseTypeDef,
    CreateAppRequestRequestTypeDef,
    DescribeAppResponseTypeDef,
    JupyterServerAppSettingsTypeDef,
    RStudioServerProDomainSettingsForUpdateTypeDef,
    RStudioServerProDomainSettingsTypeDef,
    TensorBoardAppSettingsTypeDef,
    CreateDeviceFleetRequestRequestTypeDef,
    CreateEdgePackagingJobRequestRequestTypeDef,
    DescribeDeviceFleetResponseTypeDef,
    UpdateDeviceFleetRequestRequestTypeDef,
    UpdateFeatureGroupRequestRequestTypeDef,
    CreateHumanTaskUiRequestRequestTypeDef,
    CreateNotebookInstanceInputRequestTypeDef,
    DescribeNotebookInstanceOutputTypeDef,
    UpdateNotebookInstanceInputRequestTypeDef,
    CreateNotebookInstanceLifecycleConfigInputRequestTypeDef,
    DescribeNotebookInstanceLifecycleConfigOutputTypeDef,
    UpdateNotebookInstanceLifecycleConfigInputRequestTypeDef,
    DescribePipelineResponseTypeDef,
    PipelineTypeDef,
    RetryPipelineExecutionRequestRequestTypeDef,
    UpdatePipelineExecutionRequestRequestTypeDef,
    CreatePipelineRequestRequestTypeDef,
    UpdatePipelineRequestRequestTypeDef,
    CreateTrialComponentRequestRequestTypeDef,
    UpdateTrialComponentRequestRequestTypeDef,
    CreateWorkforceRequestRequestTypeDef,
    UpdateWorkforceRequestRequestTypeDef,
    KernelGatewayAppSettingsTypeDef,
    RSessionAppSettingsTypeDef,
    ModelBiasBaselineConfigTypeDef,
    ModelExplainabilityBaselineConfigTypeDef,
    ModelQualityBaselineConfigTypeDef,
    DataQualityBaselineConfigTypeDef,
    MonitoringBaselineConfigTypeDef,
    DataSourceTypeDef,
    DatasetDefinitionTypeDef,
    DeleteDomainRequestRequestTypeDef,
    DeploymentStageTypeDef,
    DeploymentStageStatusSummaryTypeDef,
    DescribeDeviceResponseTypeDef,
    DescribeEdgePackagingJobResponseTypeDef,
    DescribeEndpointInputEndpointDeletedWaitTypeDef,
    DescribeEndpointInputEndpointInServiceWaitTypeDef,
    DescribeImageRequestImageCreatedWaitTypeDef,
    DescribeImageRequestImageDeletedWaitTypeDef,
    DescribeImageRequestImageUpdatedWaitTypeDef,
    DescribeImageVersionRequestImageVersionCreatedWaitTypeDef,
    DescribeImageVersionRequestImageVersionDeletedWaitTypeDef,
    DescribeNotebookInstanceInputNotebookInstanceDeletedWaitTypeDef,
    DescribeNotebookInstanceInputNotebookInstanceInServiceWaitTypeDef,
    DescribeNotebookInstanceInputNotebookInstanceStoppedWaitTypeDef,
    DescribeProcessingJobRequestProcessingJobCompletedOrStoppedWaitTypeDef,
    DescribeTrainingJobRequestTrainingJobCompletedOrStoppedWaitTypeDef,
    DescribeTransformJobRequestTransformJobCompletedOrStoppedWaitTypeDef,
    DescribeExperimentResponseTypeDef,
    ExperimentSummaryTypeDef,
    ExperimentTypeDef,
    FeatureGroupSummaryTypeDef,
    DescribeFeatureMetadataResponseTypeDef,
    FeatureMetadataTypeDef,
    UpdateFeatureMetadataRequestRequestTypeDef,
    DescribeHumanTaskUiResponseTypeDef,
    ListMonitoringExecutionsResponseTypeDef,
    DescribePipelineExecutionResponseTypeDef,
    DescribeSubscribedWorkteamResponseTypeDef,
    ListSubscribedWorkteamsResponseTypeDef,
    TrainingJobSummaryTypeDef,
    DescribeTrialComponentResponseTypeDef,
    TrialComponentSimpleSummaryTypeDef,
    TrialComponentSummaryTypeDef,
    DescribeTrialResponseTypeDef,
    TrialSummaryTypeDef,
    UpdateEndpointWeightsAndCapacitiesInputRequestTypeDef,
    ListStageDevicesResponseTypeDef,
    ListDeviceFleetsResponseTypeDef,
    DeviceSummaryTypeDef,
    RegisterDevicesRequestRequestTypeDef,
    UpdateDevicesRequestRequestTypeDef,
    ListDomainsResponseTypeDef,
    DriftCheckBiasTypeDef,
    DriftCheckExplainabilityTypeDef,
    ListEdgeDeploymentPlansResponseTypeDef,
    GetDeviceFleetReportResponseTypeDef,
    ListEdgePackagingJobsResponseTypeDef,
    ListEndpointConfigsOutputTypeDef,
    EndpointPerformanceTypeDef,
    ListEndpointsOutputTypeDef,
    ModelConfigurationTypeDef,
    NestedFiltersTypeDef,
    HyperParameterTrainingJobSummaryTypeDef,
    ListFlowDefinitionsResponseTypeDef,
    GetSearchSuggestionsResponseTypeDef,
    UpdateCodeRepositoryInputRequestTypeDef,
    HumanLoopActivationConfigTypeDef,
    ListHumanTaskUisResponseTypeDef,
    HyperParameterTuningResourceConfigTypeDef,
    HyperParameterTuningJobSummaryTypeDef,
    HyperParameterTuningJobStrategyConfigTypeDef,
    HyperParameterTuningJobWarmStartConfigTypeDef,
    ImageConfigTypeDef,
    ListImagesResponseTypeDef,
    ListImageVersionsResponseTypeDef,
    ListInferenceRecommendationsJobsResponseTypeDef,
    ResourceConfigTypeDef,
    ParameterRangeTypeDef,
    ParameterRangesTypeDef,
    KernelGatewayImageConfigTypeDef,
    LabelingJobForWorkteamSummaryTypeDef,
    LabelingJobDataSourceTypeDef,
    ListLineageGroupsResponseTypeDef,
    ListActionsRequestListActionsPaginateTypeDef,
    ListAlgorithmsInputListAlgorithmsPaginateTypeDef,
    ListAppImageConfigsRequestListAppImageConfigsPaginateTypeDef,
    ListAppsRequestListAppsPaginateTypeDef,
    ListArtifactsRequestListArtifactsPaginateTypeDef,
    ListAssociationsRequestListAssociationsPaginateTypeDef,
    ListAutoMLJobsRequestListAutoMLJobsPaginateTypeDef,
    ListCandidatesForAutoMLJobRequestListCandidatesForAutoMLJobPaginateTypeDef,
    ListCodeRepositoriesInputListCodeRepositoriesPaginateTypeDef,
    ListCompilationJobsRequestListCompilationJobsPaginateTypeDef,
    ListContextsRequestListContextsPaginateTypeDef,
    ListDataQualityJobDefinitionsRequestListDataQualityJobDefinitionsPaginateTypeDef,
    ListDeviceFleetsRequestListDeviceFleetsPaginateTypeDef,
    ListDevicesRequestListDevicesPaginateTypeDef,
    ListDomainsRequestListDomainsPaginateTypeDef,
    ListEdgeDeploymentPlansRequestListEdgeDeploymentPlansPaginateTypeDef,
    ListEdgePackagingJobsRequestListEdgePackagingJobsPaginateTypeDef,
    ListEndpointConfigsInputListEndpointConfigsPaginateTypeDef,
    ListEndpointsInputListEndpointsPaginateTypeDef,
    ListExperimentsRequestListExperimentsPaginateTypeDef,
    ListFeatureGroupsRequestListFeatureGroupsPaginateTypeDef,
    ListFlowDefinitionsRequestListFlowDefinitionsPaginateTypeDef,
    ListHumanTaskUisRequestListHumanTaskUisPaginateTypeDef,
    ListHyperParameterTuningJobsRequestListHyperParameterTuningJobsPaginateTypeDef,
    ListImageVersionsRequestListImageVersionsPaginateTypeDef,
    ListImagesRequestListImagesPaginateTypeDef,
    ListInferenceRecommendationsJobStepsRequestListInferenceRecommendationsJobStepsPaginateTypeDef,
    ListInferenceRecommendationsJobsRequestListInferenceRecommendationsJobsPaginateTypeDef,
    ListLabelingJobsForWorkteamRequestListLabelingJobsForWorkteamPaginateTypeDef,
    ListLabelingJobsRequestListLabelingJobsPaginateTypeDef,
    ListLineageGroupsRequestListLineageGroupsPaginateTypeDef,
    ListModelBiasJobDefinitionsRequestListModelBiasJobDefinitionsPaginateTypeDef,
    ListModelExplainabilityJobDefinitionsRequestListModelExplainabilityJobDefinitionsPaginateTypeDef,
    ListModelPackageGroupsInputListModelPackageGroupsPaginateTypeDef,
    ListModelPackagesInputListModelPackagesPaginateTypeDef,
    ListModelQualityJobDefinitionsRequestListModelQualityJobDefinitionsPaginateTypeDef,
    ListModelsInputListModelsPaginateTypeDef,
    ListMonitoringExecutionsRequestListMonitoringExecutionsPaginateTypeDef,
    ListMonitoringSchedulesRequestListMonitoringSchedulesPaginateTypeDef,
    ListNotebookInstanceLifecycleConfigsInputListNotebookInstanceLifecycleConfigsPaginateTypeDef,
    ListNotebookInstancesInputListNotebookInstancesPaginateTypeDef,
    ListPipelineExecutionStepsRequestListPipelineExecutionStepsPaginateTypeDef,
    ListPipelineExecutionsRequestListPipelineExecutionsPaginateTypeDef,
    ListPipelineParametersForExecutionRequestListPipelineParametersForExecutionPaginateTypeDef,
    ListPipelinesRequestListPipelinesPaginateTypeDef,
    ListProcessingJobsRequestListProcessingJobsPaginateTypeDef,
    ListStageDevicesRequestListStageDevicesPaginateTypeDef,
    ListStudioLifecycleConfigsRequestListStudioLifecycleConfigsPaginateTypeDef,
    ListSubscribedWorkteamsRequestListSubscribedWorkteamsPaginateTypeDef,
    ListTagsInputListTagsPaginateTypeDef,
    ListTrainingJobsForHyperParameterTuningJobRequestListTrainingJobsForHyperParameterTuningJobPaginateTypeDef,
    ListTrainingJobsRequestListTrainingJobsPaginateTypeDef,
    ListTransformJobsRequestListTransformJobsPaginateTypeDef,
    ListTrialComponentsRequestListTrialComponentsPaginateTypeDef,
    ListTrialsRequestListTrialsPaginateTypeDef,
    ListUserProfilesRequestListUserProfilesPaginateTypeDef,
    ListWorkforcesRequestListWorkforcesPaginateTypeDef,
    ListWorkteamsRequestListWorkteamsPaginateTypeDef,
    SearchRequestSearchPaginateTypeDef,
    ListDataQualityJobDefinitionsResponseTypeDef,
    ListModelBiasJobDefinitionsResponseTypeDef,
    ListModelExplainabilityJobDefinitionsResponseTypeDef,
    ListModelQualityJobDefinitionsResponseTypeDef,
    ListModelMetadataResponseTypeDef,
    ListModelPackageGroupsOutputTypeDef,
    ListModelPackagesOutputTypeDef,
    ListModelsOutputTypeDef,
    ListMonitoringSchedulesResponseTypeDef,
    ListNotebookInstanceLifecycleConfigsOutputTypeDef,
    ListNotebookInstancesOutputTypeDef,
    ListPipelineExecutionsResponseTypeDef,
    ListPipelineParametersForExecutionResponseTypeDef,
    PipelineExecutionTypeDef,
    StartPipelineExecutionRequestRequestTypeDef,
    ListPipelinesResponseTypeDef,
    ListProcessingJobsResponseTypeDef,
    ListProjectsOutputTypeDef,
    ListStudioLifecycleConfigsResponseTypeDef,
    ListTransformJobsResponseTypeDef,
    ListUserProfilesResponseTypeDef,
    MemberDefinitionTypeDef,
    ModelPackageContainerDefinitionTypeDef,
    RecommendationJobStoppingConditionsTypeDef,
    ModelMetadataSearchExpressionTypeDef,
    ModelPackageStatusDetailsTypeDef,
    MonitoringResourcesTypeDef,
    MonitoringDatasetFormatTypeDef,
    MonitoringOutputTypeDef,
    OfflineStoreConfigTypeDef,
    OnlineStoreConfigTypeDef,
    OutputConfigTypeDef,
    PendingProductionVariantSummaryTypeDef,
    ProductionVariantSummaryTypeDef,
    TrafficPatternTypeDef,
    ProcessingResourcesTypeDef,
    ProcessingOutputTypeDef,
    ProductionVariantTypeDef,
    SuggestionQueryTypeDef,
    ServiceCatalogProvisioningDetailsTypeDef,
    ServiceCatalogProvisioningUpdateDetailsTypeDef,
    PublicWorkforceTaskPriceTypeDef,
    QueryLineageRequestRequestTypeDef,
    QueryLineageResponseTypeDef,
    RecommendationJobOutputConfigTypeDef,
    RecommendationJobContainerConfigTypeDef,
    RenderUiTemplateRequestRequestTypeDef,
    RenderUiTemplateResponseTypeDef,
    UpdateTrainingJobRequestRequestTypeDef,
    SourceAlgorithmSpecificationTypeDef,
    TransformDataSourceTypeDef,
    WorkforceTypeDef,
    ListActionsResponseTypeDef,
    ArtifactSummaryTypeDef,
    CreateArtifactRequestRequestTypeDef,
    DeleteArtifactRequestRequestTypeDef,
    DescribeArtifactResponseTypeDef,
    ListAssociationsResponseTypeDef,
    AsyncInferenceConfigTypeDef,
    AutoMLChannelTypeDef,
    ListAutoMLJobsResponseTypeDef,
    AutoMLJobConfigTypeDef,
    LabelingJobAlgorithmsConfigTypeDef,
    ModelMetricsTypeDef,
    PipelineExecutionStepMetadataTypeDef,
    AutoMLCandidateTypeDef,
    BlueGreenUpdatePolicyTypeDef,
    EndpointInputConfigurationTypeDef,
    ClarifyExplainerConfigTypeDef,
    ListCodeRepositoriesOutputTypeDef,
    ListContextsResponseTypeDef,
    DomainSettingsForUpdateTypeDef,
    DomainSettingsTypeDef,
    UserSettingsTypeDef,
    ChannelTypeDef,
    ProcessingInputTypeDef,
    CreateEdgeDeploymentPlanRequestRequestTypeDef,
    CreateEdgeDeploymentStageRequestRequestTypeDef,
    DescribeEdgeDeploymentPlanResponseTypeDef,
    ListExperimentsResponseTypeDef,
    ListFeatureGroupsResponseTypeDef,
    ListTrainingJobsResponseTypeDef,
    TrialTypeDef,
    ListTrialComponentsResponseTypeDef,
    ListTrialsResponseTypeDef,
    ListDevicesResponseTypeDef,
    DriftCheckBaselinesTypeDef,
    InferenceRecommendationTypeDef,
    RecommendationJobInferenceBenchmarkTypeDef,
    SearchExpressionTypeDef,
    ListTrainingJobsForHyperParameterTuningJobResponseTypeDef,
    ListHyperParameterTuningJobsResponseTypeDef,
    ContainerDefinitionTypeDef,
    HyperParameterSpecificationTypeDef,
    HyperParameterTuningJobConfigTypeDef,
    AppImageConfigDetailsTypeDef,
    CreateAppImageConfigRequestRequestTypeDef,
    DescribeAppImageConfigResponseTypeDef,
    UpdateAppImageConfigRequestRequestTypeDef,
    ListLabelingJobsForWorkteamResponseTypeDef,
    LabelingJobInputConfigTypeDef,
    CreateWorkteamRequestRequestTypeDef,
    UpdateWorkteamRequestRequestTypeDef,
    WorkteamTypeDef,
    AdditionalInferenceSpecificationDefinitionTypeDef,
    InferenceSpecificationTypeDef,
    ListModelMetadataRequestListModelMetadataPaginateTypeDef,
    ListModelMetadataRequestRequestTypeDef,
    BatchTransformInputTypeDef,
    MonitoringOutputConfigTypeDef,
    CreateFeatureGroupRequestRequestTypeDef,
    DescribeFeatureGroupResponseTypeDef,
    FeatureGroupTypeDef,
    CreateCompilationJobRequestRequestTypeDef,
    DescribeCompilationJobResponseTypeDef,
    PendingDeploymentSummaryTypeDef,
    ProcessingOutputConfigTypeDef,
    GetSearchSuggestionsRequestRequestTypeDef,
    CreateProjectInputRequestTypeDef,
    DescribeProjectOutputTypeDef,
    ProjectTypeDef,
    UpdateProjectInputRequestTypeDef,
    HumanLoopConfigTypeDef,
    HumanTaskConfigTypeDef,
    TransformInputTypeDef,
    DescribeWorkforceResponseTypeDef,
    ListWorkforcesResponseTypeDef,
    UpdateWorkforceResponseTypeDef,
    ListArtifactsResponseTypeDef,
    CreateAutoMLJobRequestRequestTypeDef,
    PipelineExecutionStepTypeDef,
    DescribeAutoMLJobResponseTypeDef,
    ListCandidatesForAutoMLJobResponseTypeDef,
    DeploymentConfigTypeDef,
    RecommendationJobInputConfigTypeDef,
    ExplainerConfigTypeDef,
    CreateDomainRequestRequestTypeDef,
    CreateUserProfileRequestRequestTypeDef,
    DescribeDomainResponseTypeDef,
    DescribeUserProfileResponseTypeDef,
    UpdateDomainRequestRequestTypeDef,
    UpdateUserProfileRequestRequestTypeDef,
    CreateTrainingJobRequestRequestTypeDef,
    DescribeTrainingJobResponseTypeDef,
    HyperParameterTrainingJobDefinitionTypeDef,
    TrainingJobDefinitionTypeDef,
    TrainingJobTypeDef,
    InferenceRecommendationsJobStepTypeDef,
    CreateModelInputRequestTypeDef,
    DescribeModelOutputTypeDef,
    TrainingSpecificationTypeDef,
    ListAppImageConfigsResponseTypeDef,
    LabelingJobSummaryTypeDef,
    DescribeWorkteamResponseTypeDef,
    ListWorkteamsResponseTypeDef,
    UpdateWorkteamResponseTypeDef,
    UpdateModelPackageInputRequestTypeDef,
    BatchDescribeModelPackageSummaryTypeDef,
    DataQualityJobInputTypeDef,
    ModelBiasJobInputTypeDef,
    ModelExplainabilityJobInputTypeDef,
    ModelQualityJobInputTypeDef,
    MonitoringInputTypeDef,
    CreateProcessingJobRequestRequestTypeDef,
    DescribeProcessingJobResponseTypeDef,
    ProcessingJobTypeDef,
    CreateFlowDefinitionRequestRequestTypeDef,
    DescribeFlowDefinitionResponseTypeDef,
    CreateLabelingJobRequestRequestTypeDef,
    DescribeLabelingJobResponseTypeDef,
    CreateTransformJobRequestRequestTypeDef,
    DescribeTransformJobResponseTypeDef,
    TransformJobDefinitionTypeDef,
    TransformJobTypeDef,
    ListPipelineExecutionStepsResponseTypeDef,
    CreateEndpointInputRequestTypeDef,
    UpdateEndpointInputRequestTypeDef,
    CreateInferenceRecommendationsJobRequestRequestTypeDef,
    DescribeInferenceRecommendationsJobResponseTypeDef,
    CreateEndpointConfigInputRequestTypeDef,
    DescribeEndpointConfigOutputTypeDef,
    DescribeEndpointOutputTypeDef,
    CreateHyperParameterTuningJobRequestRequestTypeDef,
    DescribeHyperParameterTuningJobResponseTypeDef,
    HyperParameterTuningJobSearchEntityTypeDef,
    ListInferenceRecommendationsJobStepsResponseTypeDef,
    ListLabelingJobsResponseTypeDef,
    BatchDescribeModelPackageOutputTypeDef,
    CreateDataQualityJobDefinitionRequestRequestTypeDef,
    DescribeDataQualityJobDefinitionResponseTypeDef,
    CreateModelBiasJobDefinitionRequestRequestTypeDef,
    DescribeModelBiasJobDefinitionResponseTypeDef,
    CreateModelExplainabilityJobDefinitionRequestRequestTypeDef,
    DescribeModelExplainabilityJobDefinitionResponseTypeDef,
    CreateModelQualityJobDefinitionRequestRequestTypeDef,
    DescribeModelQualityJobDefinitionResponseTypeDef,
    MonitoringJobDefinitionTypeDef,
    AlgorithmValidationProfileTypeDef,
    ModelPackageValidationProfileTypeDef,
    TrialComponentSourceDetailTypeDef,
    MonitoringScheduleConfigTypeDef,
    AlgorithmValidationSpecificationTypeDef,
    ModelPackageValidationSpecificationTypeDef,
    TrialComponentTypeDef,
    CreateMonitoringScheduleRequestRequestTypeDef,
    DescribeMonitoringScheduleResponseTypeDef,
    MonitoringScheduleTypeDef,
    UpdateMonitoringScheduleRequestRequestTypeDef,
    CreateAlgorithmInputRequestTypeDef,
    DescribeAlgorithmOutputTypeDef,
    CreateModelPackageInputRequestTypeDef,
    DescribeModelPackageOutputTypeDef,
    ModelPackageTypeDef,
    EndpointTypeDef,
    SearchRecordTypeDef,
    SearchResponseTypeDef,
)


def get_structure() -> ActionSourceTypeDef:
    return {...}
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-sagemaker` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
