from dataclasses import dataclass


@dataclass
class DatabaseCredentials:
    """
    Represents the credentials required to connect to a database.

    Attributes:
        host (str): The hostname or IP address of the database server.
        username (str): The username for authenticating with the database.
        password (str): The password for authenticating with the database.
    """

    host: str
    username: str
    password: str
