from .database_credentials import DatabaseCredentials
from .base_client import DatabaseClient

from .pyodbc_client import PyodbcClient
from .sqlalchemy_client import SqlalchemyClient

__all__ = [
    "DatabaseClient",
    "DatabaseCredentials",
    "PyodbcClient",
    "SqlalchemyClient",
]

backends = {
    "pyodbc": PyodbcClient,
    "sqlalchemy": SqlalchemyClient,
}


def create_client(database: str, credentials: DatabaseCredentials, backend: str, **kwargs) -> DatabaseClient:
    if backend not in backends:
        raise ValueError(f"Unsupported backend: {backend}. Supported backends are: {', '.join(backends)}")

    return backends[backend](credentials=credentials, database=database, **kwargs)
