import time

import tableauserverclient as tsc
import dotenv

dotenv.load_dotenv()


def create_schedule(schedule_name: str) -> str:
    interval = tsc.HourlyInterval(start_time=time(8, 00), end_time=time(18, 00), interval_value=2)
    return tsc.ScheduleItem(
        schedule_name,
        50,
        tsc.ScheduleItem.Type.Extract,
        tsc.ScheduleItem.ExecutionOrder.Parallel,
        interval,
    )


def create_tableau_workbook(project_id: str, workbook_name: str, views_to_hide: list[str]) -> tsc.WorkbookItem:
    workbook = tsc.WorkbookItem(project_id=project_id, name=workbook_name)
    workbook.hidden_views = views_to_hide
    return workbook


def create_data_connection(server: str, username: str, password: str) -> tsc.ConnectionItem:
    connection = tsc.ConnectionItem()
    connection.server_address = server

    connection.connection_credentials = tsc.ConnectionCredentials(username, password, embed=True)

    return connection


def format_workbook_url(server: str, url: str, site: str) -> str:
    workbook_id = url.split("/")[-1]
    return f"{server}/#/site/{site}/workbooks/{workbook_id}"
