import functools
from fastapi import APIRouter, Depends

from vm_mssql_client.base_client import DatabaseClient

from helpers import get_database_client


router = APIRouter()


@router.get("/taxateurs")
def fetch_taxateurs(
    database_client: DatabaseClient = Depends(functools.partial(get_database_client, database="ww_dwh")),
):
    response = [
        i[0]
        for i in database_client.execute_query(
            "SELECT Taxateur_toegang FROM DWH.Lookup_Taxateur_toegang", return_results=True
        )
    ]

    return {"taxateurs": response}


@router.get("/snapshots")
def fetch_snapshots(
    database_client: DatabaseClient = Depends(functools.partial(get_database_client, database="ww_dwh")),
):
    response = {
        i[0]: i[1]
        for i in database_client.execute_query(
            "SELECT SnapshotID, Snapshot_omschrijving FROM m_snapshot", return_results=True
        )
    }

    return {"snapshots": response}


@router.get("/versions")
def fetch_versions(
    database_client: DatabaseClient = Depends(functools.partial(get_database_client, database="ww_dwh")),
):
    response = {
        i[0]: i[1]
        for i in database_client.execute_query(
            "SELECT VersieID, Versie_label FROM m_snapshot_versie", return_results=True
        )
    }

    return {"versions": response}
