from jinja2 import Environment, FileSystemLoader
import sib_api_v3_sdk
import os
from dotenv import load_dotenv

load_dotenv()


class BrevoClient(object):
    def __init__(self) -> None:
        self.configuration = sib_api_v3_sdk.Configuration()
        self.configuration.api_key["api-key"] = os.environ["BREVO_API_KEY"]
        self.client = sib_api_v3_sdk.TransactionalEmailsApi(sib_api_v3_sdk.ApiClient(self.configuration))

    def send_email(self, subject: str, recipients: list[dict], html: str):
        mail = sib_api_v3_sdk.SendSmtpEmail(
            subject=subject,
            to=recipients,
            html_content=html,
            sender={"name": "ValueMetrics", "email": "dev@valuemetrics.nl"},
        )
        self.client.send_transac_email(mail)


def render_template(template_name, publications: list[dict]):
    env = Environment(loader=FileSystemLoader("../src"))
    template = env.get_template(template_name)
    return template.render(publications=publications)
