import fastapi
from fastapi.middleware.cors import CORSMiddleware
import dotenv

from routers import main, lwi, workbook

dotenv.load_dotenv()


app = fastapi.FastAPI(title="vm-tableau-publisher-api", docs_url="/api/docs")
app.add_middleware(
    CORSMiddleware,
    allow_origins=["http://localhost:8080"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

app.include_router(main.router, prefix="/api")
app.include_router(workbook.router, prefix="/api/workbook", tags=["workbook"])
app.include_router(lwi.router, prefix="/api/lwi", tags=["LWI"])


if __name__ == "__main__":
    import uvicorn

    uvicorn.run(app, host="0.0.0.0", port=8000)
