from dataclasses import dataclass
from typing import Optional


@dataclass
class ClientManagerConfig:
    """Configuration class for client manager settings."""

    # Validation settings
    validate_clients: bool = False
    validation_url: Optional[str] = None
    validation_timeout: float = 10.0
    validation_retries: int = 2
    validation_retry_delay: float = 1.0

    # Health monitoring settings
    health_check_interval: float = 10.0  # 5 minutes
    health_check_enabled: bool = True
    health_check_timeout: float = 5.0

    # Pool management settings
    quarantine_duration: float = 1800.0  # 30 minutes
    max_pool_size: Optional[int] = None
    min_active_clients: int = 1

    # Monitoring settings
    max_concurrent_health_checks: int = 10

    # Default user agents
    default_user_agents: list[str] = None

    default_headers: dict[str, str] = None
