class ClientManagerError(Exception):
    """Base exception for client manager errors."""

    pass


class ClientValidationError(ClientManagerError):
    """Raised when client validation fails."""

    pass


class ClientPoolEmptyError(ClientManagerError):
    """Raised when no active clients are available."""

    pass


class ClientConnectionError(ClientManagerError):
    """Raised when client connection fails."""

    pass
